/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.debug.tests.viewer.model.VisibleVirtualItemValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.junit.Before;
import org.junit.Test;

public abstract class PerformanceTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    protected VisibleVirtualItemValidator fVirtualItemValidator;

    public String getDefaultScenarioId() {
        return this.getClass().getName() + "#" + this.name.getMethodName() + "()";
    }

    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, false, false);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fVirtualItemValidator = new VisibleVirtualItemValidator(0, Integer.MAX_VALUE);
    }

    protected abstract int getTestModelDepth();

    @Test
    public void testRefreshStruct() throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements(model, this.getTestModelDepth(), "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(this.getDefaultScenarioId());
        try {
            int i = 0;
            while (i < 10) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                this.waitWhile(t -> !this.fListener.isFinished(12543), this.createListenerErrorMessage());
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    @Test
    public void testRefreshStruct2() throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements2(model, new int[]{2, 3000, 1}, "model."));
        this.fViewer.setAutoExpandLevel(2);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        this.fVirtualItemValidator.setVisibleRange(0, 50);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(this.getDefaultScenarioId());
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset();
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                this.waitWhile(t -> !this.fListener.isFinished(12543), this.createListenerErrorMessage());
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    @Test
    public void testRefreshStructReplaceElements() throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements(model, this.getTestModelDepth(), "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(this.getDefaultScenarioId());
        try {
            int i = 0;
            while (i < 100) {
                model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements(model, this.getTestModelDepth(), "pass " + i + "."));
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                this.waitWhile(t -> !this.fListener.isFinished(12543), this.createListenerErrorMessage());
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    @Test
    public void testRefreshList() throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        int numElements = (int)Math.pow(2.0, this.getTestModelDepth());
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, numElements, "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(this.getDefaultScenarioId());
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                this.waitWhile(t -> !this.fListener.isFinished(12543), this.createListenerErrorMessage());
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    @Test
    public void testSaveAndRestore() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3.2.3")));
        this.fViewer.setAutoExpandLevel(-1);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(this.getDefaultScenarioId());
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                this.fListener.reset(true, false);
                meter.start();
                this.fViewer.setInput(null);
                this.waitWhile(t -> !this.fListener.isFinished(256), this.createListenerErrorMessage());
                this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
                this.fViewer.setInput((Object)model.getRootElement());
                this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    @Test
    public void testRefreshListFiltered() throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        int numElements = (int)Math.pow(2.0, this.getTestModelDepth());
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, numElements, "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TestModel.TestElement) {
                    String id = ((TestModel.TestElement)((Object)element)).getID();
                    if (id.startsWith("model.")) {
                        id = id.substring("model.".length());
                    }
                    if (id.length() >= 2 && (id.charAt(1) == '1' || id.charAt(1) == '3' || id.charAt(1) == '5' || id.charAt(1) == '7' || id.charAt(1) == '9')) {
                        return false;
                    }
                }
                return true;
            }
        });
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(this.getDefaultScenarioId());
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                this.waitWhile(t -> !this.fListener.isFinished(12543), this.createListenerErrorMessage());
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }
}

