/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.junit.Assert;
import org.junit.Test;

public abstract class SelectionTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, false, false);
    }

    private TestModel makeMultiLevelModel() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        return model;
    }

    @Test
    public void testSimpleSetSelection() throws Exception {
        TestModel model = this.makeMultiLevelModel();
        SelectionListener listener = new SelectionListener();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        TreeSelection selection = new TreeSelection(model.findElement("3.3.3"));
        this.fViewer.setSelection((ISelection)selection, true, false);
        Assert.assertTrue((listener.fEvents.size() == 1 ? 1 : 0) != 0);
        ISelection viewerSelection = this.fViewer.getSelection();
        Assert.assertEquals((Object)selection, (Object)viewerSelection);
    }

    @Test
    public void testSelectionPolicy() throws Exception {
        TestModel model = this.makeMultiLevelModel();
        TreeSelection selection_3_3_3 = new TreeSelection(model.findElement("3.3.3"));
        this.fViewer.setSelection((ISelection)selection_3_3_3, true, false);
        Assert.assertEquals((Object)selection_3_3_3, (Object)this.fViewer.getSelection());
        model.setSelectionPolicy(new IModelSelectionPolicy(){

            public ISelection replaceInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
                return null;
            }

            public boolean overrides(ISelection existing, ISelection candidate, IPresentationContext context) {
                return false;
            }

            public boolean isSticky(ISelection selection, IPresentationContext context) {
                return true;
            }

            public boolean contains(ISelection selection, IPresentationContext context) {
                return true;
            }
        });
        TreeSelection selection_3_3_1 = new TreeSelection(model.findElement("3.3.1"));
        this.fViewer.setSelection((ISelection)selection_3_3_1, true, false);
        Assert.assertEquals((Object)selection_3_3_3, (Object)this.fViewer.getSelection());
        this.fViewer.setSelection((ISelection)selection_3_3_1, true, true);
        Assert.assertEquals((Object)selection_3_3_1, (Object)this.fViewer.getSelection());
        TreePath path_3_3_3 = model.findElement("3.3.3");
        ModelDelta baseDelta = new ModelDelta((Object)model.getRootElement(), 0);
        ModelDelta delta_3_3_3 = model.getElementDelta(baseDelta, path_3_3_3, false);
        delta_3_3_3.setFlags(0x200000);
        this.fViewer.updateViewer((IModelDelta)baseDelta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        Assert.assertEquals((Object)selection_3_3_1, (Object)this.fViewer.getSelection());
        delta_3_3_3.setFlags(0x4200000);
        this.fViewer.updateViewer((IModelDelta)baseDelta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        Assert.assertEquals((Object)selection_3_3_3, (Object)this.fViewer.getSelection());
    }

    @Test
    public void testSelectRemove() throws Exception {
        TestModel model = this.makeMultiLevelModel();
        TreePath elementPath = model.findElement("3.3.3");
        TreeSelection selection = new TreeSelection(elementPath);
        this.fViewer.setSelection((ISelection)selection, true, false);
        TreePath removePath = model.findElement("3");
        TreePath parentPath = removePath.getParentPath();
        int removeIndex = model.getElement(parentPath).indexOf(model.getElement(removePath));
        ModelDelta delta = model.removeElementChild(removePath.getParentPath(), removeIndex);
        SelectionListener listener = new SelectionListener();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        ISelection viewerSelection = this.fViewer.getSelection();
        Assert.assertTrue((boolean)viewerSelection.isEmpty());
    }

    @Test
    public void testSelectRemoveRefreshStruct() throws Exception {
        TestModel model = this.makeMultiLevelModel();
        TreePath elementPath = model.findElement("3.3.3");
        TreeSelection selection = new TreeSelection(elementPath);
        this.fViewer.setSelection((ISelection)selection, true, false);
        TreePath removePath = model.findElement("3");
        TreePath parentPath = removePath.getParentPath();
        int removeIndex = model.getElement(parentPath).indexOf(model.getElement(removePath));
        model.removeElementChild(removePath.getParentPath(), removeIndex);
        SelectionListener listener = new SelectionListener();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        ISelection viewerSelection = this.fViewer.getSelection();
        Assert.assertTrue((boolean)viewerSelection.isEmpty());
    }

    private static class SelectionListener
    implements ISelectionChangedListener {
        private final List<SelectionChangedEvent> fEvents = new ArrayList<SelectionChangedEvent>(1);

        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fEvents.add(event);
        }
    }
}

