/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.junit.Assert;
import org.junit.Test;

public abstract class StateTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, false, false);
    }

    protected IInternalTreeModelViewer getInternalViewer() {
        return this.fViewer;
    }

    @Test
    public void testUpdateViewer() throws Exception {
        ModelDelta delta;
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset();
        this.fListener.addChildreUpdate(TreePath.EMPTY, 0);
        this.fListener.addChildreUpdate(TreePath.EMPTY, 1);
        this.fListener.addChildreUpdate(TreePath.EMPTY, 2);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        TestModel.TestElement element = model.getRootElement();
        TreePath path0 = TreePath.EMPTY;
        ModelDelta updateDelta = delta = new ModelDelta((Object)model.getRootElement(), -1, 0x100000, element.getChildren().length);
        element = element.getChildren()[2];
        TreePath path1 = path0.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 2, 0x100000, element.fChildren.length);
        element = element.getChildren()[1];
        TreePath path2 = path1.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 1, 0x100000, element.fChildren.length);
        element = element.getChildren()[1];
        TreePath path3 = path2.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 1, 0x200000);
        this.fListener.reset(false, false);
        this.fListener.addChildreUpdate(path0, 2);
        this.fListener.addHasChildrenUpdate(path1);
        this.fListener.addChildreCountUpdate(path1);
        this.fListener.addLabelUpdate(path1);
        this.fListener.addChildreUpdate(path1, 1);
        this.fListener.addHasChildrenUpdate(path2);
        this.fListener.addChildreCountUpdate(path2);
        this.fListener.addLabelUpdate(path2);
        this.fListener.addHasChildrenUpdate(path2);
        this.fListener.addChildreCountUpdate(path2);
        this.fListener.addChildreUpdate(path2, 1);
        this.fListener.addHasChildrenUpdate(path3);
        this.fListener.addLabelUpdate(path3);
        this.fViewer.updateViewer((IModelDelta)updateDelta);
        this.waitWhile(t -> !this.fListener.isFinished(6), this.createListenerErrorMessage());
        ModelDelta savedDelta = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(path0, savedDelta, 0x300000);
        if (!this.deltaMatches(updateDelta, savedDelta)) {
            Assert.fail((String)("Expected:\n" + String.valueOf(updateDelta) + "\nGot:\n" + String.valueOf(savedDelta)));
        }
    }

    boolean deltaMatches(ModelDelta requested, ModelDelta received) {
        if (requested.getElement().equals(received.getElement()) && requested.getFlags() == received.getFlags() && (requested.getChildCount() == -1 || requested.getChildCount() == received.getChildCount()) && (requested.getIndex() == -1 || requested.getIndex() == received.getIndex()) && (requested.getReplacementElement() != null && requested.getReplacementElement().equals(received.getReplacementElement()) || requested.getReplacementElement() == null && received.getReplacementElement() == null) && requested.getChildDeltas().length == received.getChildDeltas().length) {
            int i = 0;
            while (i < requested.getChildDeltas().length) {
                ModelDelta requestedChildDelta = (ModelDelta)requested.getChildDeltas()[i];
                ModelDelta receivedChildDelta = received.getChildDelta(requestedChildDelta.getElement());
                if (receivedChildDelta == null || !this.deltaMatches(requestedChildDelta, receivedChildDelta)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static TestModel alternatingSubsreesModel(int size) {
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[size];
        int i = 0;
        while (i < size) {
            String text = Integer.toString(i + 1);
            elements[i] = new TestModel.TestElement(model, text, new TestModel.TestElement[]{new TestModel.TestElement(model, text + ".1", new TestModel.TestElement[]{new TestModel.TestElement(model, text + ".1.1", new TestModel.TestElement[0])})});
            ++i;
        }
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        return model;
    }

    static TestModel alternatingSubtreesModelWithChildren(int size, int childrenCount, final Supplier<Boolean> shouldReturnChildren) {
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[size];
        int i = 0;
        while (i < size) {
            String text = Integer.toString(i + 1);
            TestModel.TestElement[] children = new TestModel.TestElement[childrenCount];
            int x = 0;
            while (x < childrenCount) {
                children[x] = new TestModel.TestElement(model, text + "." + (x + 1), new TestModel.TestElement[0]);
                ++x;
            }
            elements[i] = new TestModel.TestElement(model, text, children){

                @Override
                public TestModel.TestElement[] getChildren() {
                    if (((Boolean)shouldReturnChildren.get()).booleanValue()) {
                        return super.getChildren();
                    }
                    return new TestModel.TestElement[0];
                }
            };
            ++i;
        }
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        return model;
    }

    static boolean areTreeSelectionsEqual(ITreeSelection sel1, ITreeSelection sel2) {
        HashSet<TreePath> sel1Set = new HashSet<TreePath>();
        sel1Set.addAll(Arrays.asList(sel1.getPaths()));
        HashSet<TreePath> sel2Set = new HashSet<TreePath>();
        sel2Set.addAll(Arrays.asList(sel2.getPaths()));
        return sel1Set.equals(sel2Set);
    }

    static void expandAlternateElements(TestModelUpdatesListener listener, TestModel model, boolean waitForAllUpdates) throws Exception {
        listener.reset();
        listener.setFailOnRedundantUpdates(false);
        TestModel.TestElement rootElement = model.getRootElement();
        TestModel.TestElement[] children = rootElement.getChildren();
        ModelDelta rootDelta = new ModelDelta((Object)rootElement, 0);
        ModelDelta expandDelta = model.getBaseDelta(rootDelta);
        int i = 0;
        while (i < children.length) {
            if (i % 2 != 1) {
                TestModel.TestElement element = children[i];
                ModelDelta delta = expandDelta;
                int index = i;
                while (element.getChildren().length != 0) {
                    TreePath elementPath = model.findElement(element.getLabel());
                    listener.addUpdates(elementPath, element, 1, 0x10 | (waitForAllUpdates ? 32 : 0));
                    delta = delta.addNode((Object)element, index, 0x100000, element.getChildren().length);
                    element = element.getChildren()[0];
                    index = 0;
                }
            }
            ++i;
        }
        model.postDelta((IModelDelta)rootDelta);
        TestUtil.waitWhile(t -> !listener.isFinished(66), null, 30000L, t -> "Listener not finished: " + String.valueOf(listener));
    }

    @Test
    public void testPreserveExpandedOnRemove() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        ModelDelta delta = model.removeElementChild(TreePath.EMPTY, 0);
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    @Test
    public void testPreserveExpandedOnInsert() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        ModelDelta delta = model.insertElementChild(TreePath.EMPTY, 0, new TestModel.TestElement(model, "0 - new", new TestModel.TestElement[0]));
        TreePath path = model.findElement("0 - new");
        this.fListener.reset(path, (TestModel.TestElement)((Object)path.getLastSegment()), 0, false, false);
        this.fListener.addChildreUpdate(TreePath.EMPTY, 0);
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(12543), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    @Test
    public void testPreserveExpandedOnMultLevelContent() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(new TreePath[]{model.findElement("5"), model.findElement("5.1"), model.findElement("6")});
        this.fViewer.setSelection((ISelection)originalSelection);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        model.removeElementChild(TreePath.EMPTY, 0);
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), -1, 12479);
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 1024);
        ModelDelta elementDelta = model.getElementDelta(rootDelta, model.findElement("3.1.1"), true);
        elementDelta.setFlags(1024);
        model.postDelta((IModelDelta)rootDelta);
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        Assert.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 5));
    }

    @Test
    public void testKeepCollapsedAfterRemovingAndReaddingChildrenInExpandedTree() throws Exception {
        boolean[] showChildren = new boolean[]{true};
        int size = 3;
        Supplier<Boolean> shouldShowChildren = () -> showChildren[0];
        TestModel model = StateTests.alternatingSubtreesModelWithChildren(size, 10, shouldShowChildren);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        TestModel.TestElement rootElement = model.getRootElement();
        TestModel.TestElement[] children = rootElement.getChildren();
        ModelDelta rootDelta = new ModelDelta((Object)rootElement, 0);
        ModelDelta expandDelta = model.getBaseDelta(rootDelta);
        int i = 0;
        while (i < children.length) {
            TestModel.TestElement element = children[i];
            ModelDelta delta = expandDelta;
            int index = i;
            while (element.getChildren().length != 0) {
                TreePath elementPath = model.findElement(element.getLabel());
                this.fListener.addUpdates(elementPath, element, 1, 48);
                delta = delta.addNode((Object)element, index, 0x100400, element.getChildren().length);
                element = element.getChildren()[0];
                index = 0;
            }
            ++i;
        }
        model.postDelta((IModelDelta)rootDelta);
        TestUtil.waitWhile(t -> !this.fListener.isFinished(12543), null, 300000L, t -> "Listener not finished: " + String.valueOf(this.fListener));
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        showChildren[0] = false;
        rootElement = model.getRootElement();
        ModelDelta rootDelta2 = new ModelDelta((Object)rootElement, 1024);
        model.getBaseDelta(rootDelta2);
        TreePath elementPath = TreePath.EMPTY;
        this.fListener.addUpdates(elementPath, rootElement, 2, 48);
        model.postDelta((IModelDelta)rootDelta2);
        TestUtil.waitWhile(t -> !this.fListener.isFinished(12543), null, 60000L, t -> "Listener not finished: " + String.valueOf(this.fListener));
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        showChildren[0] = true;
        rootElement = model.getRootElement();
        children = rootElement.getChildren();
        rootDelta = new ModelDelta((Object)rootElement, 0);
        ModelDelta delta = model.getBaseDelta(rootDelta);
        TestModel.TestElement element = children[0];
        delta = delta.addNode((Object)element, 0, 0x100000, element.getChildren().length);
        TreePath elementPath2 = model.findElement(element.getLabel());
        this.fListener.addUpdates(elementPath2, element, 2, 32);
        element = element.getChildren()[0];
        delta = delta.addNode((Object)element, 0, 0x200000, -1);
        model.postDelta((IModelDelta)rootDelta);
        TestUtil.waitWhile(t -> !this.fListener.isFinished(12543), null, 60000L, t -> "Listener not finished: " + String.valueOf(this.fListener));
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        showChildren[0] = true;
        rootElement = model.getRootElement();
        rootDelta2 = new ModelDelta((Object)rootElement, 1024);
        model.getBaseDelta(rootDelta2);
        TestModel.TestElement element2 = rootElement.getChildren()[0];
        TreePath elementPath3 = model.findElement(element2.getLabel());
        this.fListener.addUpdates(elementPath3, element2, 1, 32);
        model.postDelta((IModelDelta)rootDelta2);
        TestUtil.waitWhile(t -> !this.fListener.isFinished(12543), null, 6000000L, t -> "Listener not finished: " + String.valueOf(this.fListener));
        int i2 = 1;
        while (i2 <= size) {
            Assert.assertTrue((this.getInternalViewer().getExpandedState((Object)model.findElement(Integer.toString(i2))) == (i2 == 1) ? 1 : 0) != 0);
            ++i2;
        }
    }

    @Test
    public void testPreserveExpandedOnSubTreeContent() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setAutoExpandLevel(0);
        TreeSelection originalSelection = new TreeSelection(model.findElement("3.3.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        model.addElementChild(model.findElement("3"), null, 0, new TestModel.TestElement(model, "3.0 - new", new TestModel.TestElement[0]));
        TreePath elementPath = model.findElement("3");
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 0);
        ModelDelta elementDelta = model.getElementDelta(rootDelta, elementPath, true);
        elementDelta.setFlags(1024);
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getInternalViewer(), elementPath, model.getElement(elementPath), -1, 12479);
        model.postDelta((IModelDelta)rootDelta);
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.3")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    @Test
    public void testPreserveExpandedOnContentStress() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        int i = 0;
        while (i < 10) {
            model.removeElementChild(TreePath.EMPTY, 0);
            this.fListener.reset(false, false);
            this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), -1, 12479);
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
            model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
            Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
            Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
            Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
            Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
            model.addElementChild(TreePath.EMPTY, null, 0, new TestModel.TestElement(model, "1", new TestModel.TestElement[0]));
            this.fListener.reset(false, false);
            this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), -1, 12479);
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
            model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
            Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
            Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
            Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
            Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
            Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
            ++i;
        }
    }

    @Test
    public void testPreserveLargeModelOnContent() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(100);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(2), this.createListenerErrorMessage());
        StateTests.expandAlternateElements(this.fListener, model, false);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        model.removeElementChild(TreePath.EMPTY, 0);
        this.fListener.reset(false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(2), this.createListenerErrorMessage());
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        model.addElementChild(TreePath.EMPTY, null, 0, new TestModel.TestElement(model, "1", new TestModel.TestElement[0]));
        this.fListener.reset(false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(2), this.createListenerErrorMessage());
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    @Test
    public void testPreserveSelectionDeltaAfterContent() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3.1.1")));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        ModelDelta selectDelta = model.makeElementDelta(model.findElement("2.1"), 0x200000);
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)selectDelta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        Assert.assertEquals((Object)new TreeSelection(model.findElement("2.1")), (Object)this.fViewer.getSelection());
    }

    @Test
    public void testPreserveCollapseDeltaAfterContent() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setAutoExpandLevel(0);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        ModelDelta collapseDelta = model.makeElementDelta(model.findElement("3.1"), 0x2000000);
        this.fListener.resetModelChanged();
        this.fListener.removeLabelUpdate(model.findElement("3.1.1"));
        this.fListener.removeLabelUpdate(model.findElement("3.1.2"));
        this.fListener.removeLabelUpdate(model.findElement("3.1.3"));
        this.fListener.removeHasChildrenUpdate(model.findElement("3.1.1"));
        this.fListener.removeHasChildrenUpdate(model.findElement("3.1.2"));
        this.fListener.removeHasChildrenUpdate(model.findElement("3.1.3"));
        this.fListener.removeChildreCountUpdate(model.findElement("3.1"));
        this.fListener.removeChildrenUpdate(model.findElement("3.1"), 0);
        this.fListener.removeChildrenUpdate(model.findElement("3.1"), 1);
        this.fListener.removeChildrenUpdate(model.findElement("3.1"), 2);
        model.postDelta((IModelDelta)collapseDelta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
    }

    @Test
    public void testPreserveExpandDeltaAfterContent() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        ModelDelta expandDelta = model.makeElementDelta(model.findElement("3.1"), 0x100000);
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)expandDelta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
    }

    @Test
    public void testSaveAndRestore1() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("5.1"), model.findElement("5.1.1"), model.findElement("6.1.1")}));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(false, false);
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(1280), this.createListenerErrorMessage());
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            Assert.fail((String)("Expected:\n" + String.valueOf(originalState) + "\nGot:\n" + String.valueOf(restoredState)));
        }
    }

    @Test
    public void testSaveAndRestore2() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("3.2"), model.findElement("3.2.1"), model.findElement("2")}));
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3.2.3")));
        this.fViewer.setAutoExpandLevel(-1);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(1280), this.createListenerErrorMessage());
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            Assert.fail((String)("Expected:\n" + String.valueOf(originalState) + "\nGot:\n" + String.valueOf(restoredState)));
        }
    }

    @Test
    public void testSaveAndRestoreInputInstance() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("5.1"), model.findElement("5.1.1"), model.findElement("6.1.1")}));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            Assert.fail((String)("Expected:\n" + String.valueOf(originalState) + "\nGot:\n" + String.valueOf(restoredState)));
        }
    }

    @Test
    public void testSaveAndRestoreInputInstanceEquals() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("5.1"), model.findElement("5.1.1"), model.findElement("6.1.1")}));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        TestModel.TestElement newRoot = new TestModel.TestElement(model, model.getRootElement().getID(), model.getRootElement().getChildren());
        model.setRoot(newRoot);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            Assert.fail((String)("Expected:\n" + String.valueOf(originalState) + "\nGot:\n" + String.valueOf(restoredState)));
        }
    }

    @Test
    public void testSaveAndRestoreLarge() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(100);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(2), this.createListenerErrorMessage());
        StateTests.expandAlternateElements(this.fListener, model, false);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset();
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(1280), this.createListenerErrorMessage());
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(2), this.createListenerErrorMessage());
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    @Test
    public void testSaveAndRestorePartialStateLarge() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(100);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(2), this.createListenerErrorMessage());
        StateTests.expandAlternateElements(this.fListener, model, false);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset();
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(1280), this.createListenerErrorMessage());
        TestModel.TestElement[] elements = model.getRootElement().getChildren();
        TestModel.TestElement[] newElements = new TestModel.TestElement[10];
        System.arraycopy(elements, 0, newElements, 0, newElements.length);
        model.setElementChildren(TreePath.EMPTY, newElements);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(514), this.createListenerErrorMessage());
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("4")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("6")));
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    @Test
    public void testPreserveCollapseAndSelectDeltaAfterSaveAndRestore() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3")));
        this.fViewer.setAutoExpandLevel(0);
        this.fListener.reset(false, false);
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(256), this.createListenerErrorMessage());
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        TreePath path = model.findElement("2");
        this.fListener.addUpdates(null, path, (TestModel.TestElement)((Object)path.getLastSegment()), 0, 1024);
        path = model.findElement("3");
        this.fListener.addUpdates(null, path, (TestModel.TestElement)((Object)path.getLastSegment()), 0, 1024);
        this.waitWhile(t -> !this.fListener.isFinished(33555552), this.createListenerErrorMessage());
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)model.makeElementDelta(model.findElement("2"), 0x2000000));
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)model.makeElementDelta(model.findElement("3"), 0x2000000));
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        model.postDelta((IModelDelta)model.makeElementDelta(model.findElement("1"), 0x200000));
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        this.waitWhile(t -> !this.fListener.isFinished(512), this.createListenerErrorMessage());
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("2")));
        Assert.assertFalse((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertEquals((Object)new TreeSelection(model.findElement("1")), (Object)this.fViewer.getSelection());
    }

    @Test
    public void testSaveRestoreOrder() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        model.setDelayUpdates(true);
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        TestModel copyModel = TestModel.simpleMultiLevel();
        this.fListener.reset();
        this.fListener.expectRestoreAfterSaveComplete();
        this.fViewer.setInput((Object)copyModel.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(0x2000000), this.createListenerErrorMessage());
        Assert.assertTrue((String)"RESTORE started before SAVE to complete", (boolean)this.fListener.isFinished(256));
    }

    @Test
    public void testUpdateWithNullInput() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        ModelDelta expandedState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, expandedState, 0x100000);
        this.fListener.reset();
        this.fListener.addChildreCountUpdate(TreePath.EMPTY);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(80), this.createListenerErrorMessage());
        this.fViewer.setInput(null);
        this.fViewer.updateViewer((IModelDelta)expandedState);
        this.waitWhile(t -> !this.fListener.isFinished(4154), this.createListenerErrorMessage());
    }
}

