/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.ElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStateUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerFilter;
import org.junit.Assert;

public class TestModelUpdatesListener
implements IViewerUpdateListener,
ILabelUpdateListener,
IModelChangedListener,
ITestModelUpdatesListenerConstants,
IStateUpdateListener,
IJobChangeListener {
    public static final ViewerFilter[] EMPTY_FILTER_ARRAY = new ViewerFilter[0];
    private final ITreeModelViewer fViewer;
    private IStatus fJobError;
    private boolean fFailOnRedundantUpdates;
    private boolean fFailOnRedundantLabelUpdates;
    private final Set<IViewerUpdate> fRedundantUpdates = new HashSet<IViewerUpdate>();
    private final Set<ILabelUpdate> fRedundantLabelUpdates = new HashSet<ILabelUpdate>();
    private final Set<TreePath> fRedundantHasChildrenUpdateExceptions = new HashSet<TreePath>();
    private final Set<TreePath> fRedundantChildCountUpdateExceptions = new HashSet<TreePath>();
    private final Set<TreePath> fRedundantChildrenUpdateExceptions = new HashSet<TreePath>();
    private final Set<TreePath> fRedundantLabelUpdateExceptions = new HashSet<TreePath>();
    private boolean fFailOnMultipleModelUpdateSequences;
    private boolean fFailOnMultipleLabelUpdateSequences;
    private final Set<TreePath> fHasChildrenUpdatesScheduled = new HashSet<TreePath>();
    private final Set<IViewerUpdate> fHasChildrenUpdatesRunning = new HashSet<IViewerUpdate>();
    private final Set<IViewerUpdate> fHasChildrenUpdatesCompleted = new HashSet<IViewerUpdate>();
    private final Map<TreePath, Set<Integer>> fChildrenUpdatesScheduled = new HashMap<TreePath, Set<Integer>>();
    private final Set<IViewerUpdate> fChildrenUpdatesRunning = new HashSet<IViewerUpdate>();
    private final Set<IViewerUpdate> fChildrenUpdatesCompleted = new HashSet<IViewerUpdate>();
    private final Set<TreePath> fChildCountUpdatesScheduled = new HashSet<TreePath>();
    private final Set<IViewerUpdate> fChildCountUpdatesRunning = new HashSet<IViewerUpdate>();
    private final Set<IViewerUpdate> fChildCountUpdatesCompleted = new HashSet<IViewerUpdate>();
    private final Set<TreePath> fLabelUpdates = new HashSet<TreePath>();
    private final Set<ILabelUpdate> fLabelUpdatesRunning = new HashSet<ILabelUpdate>();
    private final Set<ILabelUpdate> fLabelUpdatesCompleted = new HashSet<ILabelUpdate>();
    private final Set<TestModel> fProxyModels = new HashSet<TestModel>();
    private final Set<TreePath> fStateUpdates = new HashSet<TreePath>();
    private int fViewerUpdatesStarted = 0;
    private int fViewerUpdatesComplete = 0;
    private int fViewerUpdatesStartedAtReset;
    private int fViewerUpdatesCompleteAtReset;
    private int fLabelUpdatesStarted = 0;
    private int fLabelUpdatesComplete = 0;
    private int fLabelUpdatesStartedAtReset;
    private int fLabelUpdatesCompleteAtReset;
    private boolean fModelChangedComplete;
    private boolean fStateSaveStarted;
    private boolean fStateSaveComplete;
    private boolean fStateRestoreStarted;
    private boolean fStateRestoreComplete;
    private int fViewerUpdatesCounter;
    private int fLabelUpdatesCounter;
    private int fTimeoutInterval = 60000;
    private long fTimeoutTime;
    private boolean fExpectRestoreAfterSaveComplete;
    private RuntimeException fFailExpectation;

    public TestModelUpdatesListener(ITreeModelViewer viewer, boolean failOnRedundantUpdates, boolean failOnMultipleModelUpdateSequences) {
        this(viewer);
        this.setFailOnRedundantUpdates(failOnRedundantUpdates);
        this.setFailOnMultipleModelUpdateSequences(failOnMultipleModelUpdateSequences);
    }

    public TestModelUpdatesListener(ITreeModelViewer viewer) {
        this.fViewer = viewer;
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
        this.fViewer.addLabelUpdateListener((ILabelUpdateListener)this);
        this.fViewer.addModelChangedListener((IModelChangedListener)this);
        this.fViewer.addStateUpdateListener((IStateUpdateListener)this);
        this.fViewer.addViewerUpdateListener((IViewerUpdateListener)this);
    }

    public void dispose() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
        this.fViewer.removeLabelUpdateListener((ILabelUpdateListener)this);
        this.fViewer.removeModelChangedListener((IModelChangedListener)this);
        this.fViewer.removeStateUpdateListener((IStateUpdateListener)this);
        this.fViewer.removeViewerUpdateListener((IViewerUpdateListener)this);
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        IStatus result = event.getJob().getResult();
        if (result != null && result.getSeverity() == 4) {
            this.fJobError = result;
        }
    }

    public void setFailOnRedundantUpdates(boolean failOnRedundantUpdates) {
        this.fFailOnRedundantUpdates = failOnRedundantUpdates;
    }

    public void setFailOnRedundantLabelUpdates(boolean failOnRedundantLabelUpdates) {
        this.fFailOnRedundantLabelUpdates = failOnRedundantLabelUpdates;
    }

    public void setFailOnMultipleModelUpdateSequences(boolean failOnMultipleLabelUpdateSequences) {
        this.fFailOnMultipleModelUpdateSequences = failOnMultipleLabelUpdateSequences;
    }

    public void setFailOnMultipleLabelUpdateSequences(boolean failOnMultipleLabelUpdateSequences) {
        this.fFailOnMultipleLabelUpdateSequences = failOnMultipleLabelUpdateSequences;
    }

    public void expectRestoreAfterSaveComplete() {
        this.fExpectRestoreAfterSaveComplete = true;
    }

    public void setTimeoutInterval(int milis) {
        this.fTimeoutInterval = milis;
    }

    public void reset(TreePath path, TestModel.TestElement element, int levels, boolean failOnRedundantUpdates, boolean failOnMultipleUpdateSequences) {
        this.reset(path, element, EMPTY_FILTER_ARRAY, levels, failOnRedundantUpdates, failOnMultipleUpdateSequences);
    }

    public void reset(TreePath path, TestModel.TestElement element, ViewerFilter[] filters, int levels, boolean failOnRedundantUpdates, boolean failOnMultipleUpdateSequences) {
        this.reset();
        this.addUpdates(path, element, filters, levels);
        this.addProxies(element);
        this.setFailOnRedundantUpdates(failOnRedundantUpdates);
        this.setFailOnMultipleModelUpdateSequences(failOnMultipleUpdateSequences);
        this.setFailOnMultipleLabelUpdateSequences(false);
    }

    public void reset(boolean failOnRedundantUpdates, boolean failOnMultipleUpdateSequences) {
        this.reset();
        this.setFailOnRedundantUpdates(failOnRedundantUpdates);
        this.setFailOnMultipleModelUpdateSequences(failOnMultipleUpdateSequences);
        this.setFailOnMultipleLabelUpdateSequences(false);
    }

    public void reset() {
        this.fJobError = null;
        this.fFailExpectation = null;
        this.fRedundantUpdates.clear();
        this.fRedundantLabelUpdates.clear();
        this.fRedundantHasChildrenUpdateExceptions.clear();
        this.fRedundantChildCountUpdateExceptions.clear();
        this.fRedundantChildrenUpdateExceptions.clear();
        this.fRedundantLabelUpdateExceptions.clear();
        this.fHasChildrenUpdatesScheduled.clear();
        this.fHasChildrenUpdatesRunning.clear();
        this.fHasChildrenUpdatesCompleted.clear();
        this.fChildrenUpdatesScheduled.clear();
        this.fChildrenUpdatesRunning.clear();
        this.fChildrenUpdatesCompleted.clear();
        this.fChildCountUpdatesScheduled.clear();
        this.fChildCountUpdatesRunning.clear();
        this.fChildCountUpdatesCompleted.clear();
        this.fLabelUpdates.clear();
        this.fLabelUpdatesRunning.clear();
        this.fLabelUpdatesCompleted.clear();
        this.fProxyModels.clear();
        this.fViewerUpdatesStartedAtReset = this.fViewerUpdatesStarted;
        this.fViewerUpdatesCompleteAtReset = this.fViewerUpdatesComplete;
        this.fLabelUpdatesStartedAtReset = this.fLabelUpdatesStarted;
        this.fLabelUpdatesCompleteAtReset = this.fLabelUpdatesComplete;
        this.fStateUpdates.clear();
        this.fStateSaveStarted = false;
        this.fStateSaveComplete = false;
        this.fStateRestoreStarted = false;
        this.fStateRestoreComplete = false;
        this.fExpectRestoreAfterSaveComplete = false;
        this.fTimeoutTime = System.currentTimeMillis() + (long)this.fTimeoutInterval;
        ILog.of(TestModelUpdatesListener.class).log(Status.info((String)("fTimeOut Reset: " + this.fTimeoutTime)));
        this.resetModelChanged();
    }

    public void resetModelChanged() {
        this.fModelChangedComplete = false;
    }

    public void addHasChildrenUpdate(TreePath path) {
        this.fHasChildrenUpdatesScheduled.add(path);
    }

    public void removeHasChildrenUpdate(TreePath path) {
        this.fHasChildrenUpdatesScheduled.remove(path);
    }

    public void addChildreCountUpdate(TreePath path) {
        this.fChildCountUpdatesScheduled.add(path);
    }

    public void removeChildreCountUpdate(TreePath path) {
        this.fChildCountUpdatesScheduled.remove(path);
    }

    public void addChildreUpdate(TreePath path, int index) {
        Set<Integer> childrenIndexes = this.fChildrenUpdatesScheduled.get(path);
        if (childrenIndexes == null) {
            childrenIndexes = new TreeSet<Integer>();
            this.fChildrenUpdatesScheduled.put(path, childrenIndexes);
        }
        childrenIndexes.add(index);
    }

    public void removeChildrenUpdate(TreePath path, int index) {
        Set<Integer> childrenIndexes = this.fChildrenUpdatesScheduled.get(path);
        if (childrenIndexes != null) {
            childrenIndexes.remove(index);
            if (childrenIndexes.isEmpty()) {
                this.fChildrenUpdatesScheduled.remove(path);
            }
        }
    }

    public void addLabelUpdate(TreePath path) {
        this.fLabelUpdates.add(path);
    }

    public void removeLabelUpdate(TreePath path) {
        this.fLabelUpdates.remove(path);
    }

    public void addUpdates(TreePath path, TestModel.TestElement element, int levels) {
        this.addUpdates(null, path, element, EMPTY_FILTER_ARRAY, levels, 12479);
    }

    public void addUpdates(TreePath path, TestModel.TestElement element, ViewerFilter[] filters, int levels) {
        this.addUpdates(null, path, element, filters, levels, 12479);
    }

    public void addStateUpdates(IInternalTreeModelViewer viewer, TreePath path, TestModel.TestElement element) {
        this.addUpdates(viewer, path, element, -1, 1024);
    }

    public void addStateUpdates(IInternalTreeModelViewer viewer, IModelDelta pendingDelta, int deltaFlags) {
        IModelDelta[] childDeltas;
        TreePath treePath = this.getViewerTreePath(pendingDelta);
        if (!TreePath.EMPTY.equals((Object)treePath) && (pendingDelta.getFlags() & deltaFlags) != 0) {
            this.addUpdates(viewer, treePath, (TestModel.TestElement)((Object)treePath.getLastSegment()), 0, 1024);
        }
        IModelDelta[] iModelDeltaArray = childDeltas = pendingDelta.getChildDeltas();
        int n = childDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModelDelta childDelta = iModelDeltaArray[n2];
            this.addStateUpdates(viewer, childDelta, deltaFlags);
            ++n2;
        }
    }

    public void addRedundantExceptionHasChildren(TreePath path) {
        this.fRedundantHasChildrenUpdateExceptions.add(path);
    }

    public void addRedundantExceptionChildCount(TreePath path) {
        this.fRedundantChildCountUpdateExceptions.add(path);
    }

    public void addRedundantExceptionChildren(TreePath path) {
        this.fRedundantChildrenUpdateExceptions.add(path);
    }

    public void addRedundantExceptionLabel(TreePath path) {
        this.fRedundantLabelUpdateExceptions.add(path);
    }

    public boolean checkCoalesced(TreePath path, int offset, int length) {
        for (IChildrenUpdate iChildrenUpdate : this.fChildrenUpdatesCompleted) {
            if (!path.equals((Object)iChildrenUpdate.getElementPath()) || offset != iChildrenUpdate.getOffset() || length != iChildrenUpdate.getLength()) continue;
            return true;
        }
        return false;
    }

    public Set<IViewerUpdate> getHasChildrenUpdatesCompleted() {
        return this.fHasChildrenUpdatesCompleted;
    }

    public Set<IViewerUpdate> getChildCountUpdatesCompleted() {
        return this.fChildCountUpdatesCompleted;
    }

    public Set<IViewerUpdate> getChildrenUpdatesCompleted() {
        return this.fChildrenUpdatesCompleted;
    }

    private TreePath getViewerTreePath(IModelDelta node) {
        ArrayList<Object> list = new ArrayList<Object>();
        IModelDelta currentDelta = node;
        IModelDelta parentDelta = currentDelta.getParentDelta();
        while (parentDelta != null) {
            list.add(0, currentDelta.getElement());
            currentDelta = parentDelta;
            parentDelta = currentDelta.getParentDelta();
        }
        return new TreePath(list.toArray());
    }

    public void addUpdates(TreePath path, TestModel.TestElement element, int levels, int flags) {
        this.addUpdates(null, path, element, levels, flags);
    }

    public void addUpdates(IInternalTreeModelViewer viewer, TreePath path, TestModel.TestElement element, int levels, int flags) {
        this.addUpdates(viewer, path, element, EMPTY_FILTER_ARRAY, levels, flags);
    }

    public static boolean isFiltered(Object element, ViewerFilter[] filters) {
        ViewerFilter[] viewerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!filter.select(null, null, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addUpdates(IInternalTreeModelViewer viewer, TreePath path, TestModel.TestElement element, ViewerFilter[] filters, int levels, int flags) {
        TestModel.TestElement[] children;
        if (TestModelUpdatesListener.isFiltered(path.getLastSegment(), filters)) {
            return;
        }
        if (!path.equals((Object)TreePath.EMPTY)) {
            if ((flags & 4) != 0) {
                this.fLabelUpdates.add(path);
            }
            if ((flags & 8) != 0) {
                this.fHasChildrenUpdatesScheduled.add(path);
            }
            if ((flags & 0x400) != 0) {
                this.fStateUpdates.add(path);
            }
        }
        if (levels != 0 && (children = element.getChildren()).length > 0 && (viewer == null || path.getSegmentCount() == 0 || viewer.getExpandedState((Object)path))) {
            if ((flags & 0x10) != 0) {
                this.fChildCountUpdatesScheduled.add(path);
            }
            if ((flags & 0x20) != 0) {
                HashSet<Integer> childrenIndexes = new HashSet<Integer>();
                int i = 0;
                while (i < children.length) {
                    if (!TestModelUpdatesListener.isFiltered((Object)children[i], filters)) {
                        childrenIndexes.add(i);
                    }
                    ++i;
                }
                this.fChildrenUpdatesScheduled.put(path, childrenIndexes);
            }
            TestModel.TestElement[] testElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TestModel.TestElement child = testElementArray[n2];
                this.addUpdates(viewer, path.createChildPath((Object)child), child, filters, levels - 1, flags);
                ++n2;
            }
        }
    }

    private void addProxies(TestModel.TestElement element) {
        TestModel.TestElement[] children;
        TestModel model = element.getModel();
        if (model.getModelProxy() == null) {
            this.fProxyModels.add(element.getModel());
        }
        TestModel.TestElement[] testElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TestModel.TestElement child = testElementArray[n2];
            this.addProxies(child);
            ++n2;
        }
    }

    public boolean isFinished() {
        return this.isFinished(12479);
    }

    public boolean isTimedOut() {
        return this.fTimeoutInterval > 0 && this.fTimeoutTime < System.currentTimeMillis();
    }

    public boolean isFinished(int flags) {
        if (this.isTimedOut()) {
            throw new RuntimeException("Timed Out: " + this.toString(flags));
        }
        if (this.fFailExpectation != null) {
            throw this.fFailExpectation;
        }
        if (this.fJobError != null) {
            throw new RuntimeException("Job Error: " + String.valueOf(this.fJobError));
        }
        if (this.fFailOnRedundantUpdates && !this.fRedundantUpdates.isEmpty()) {
            Assert.fail((String)("Redundant Updates: " + String.valueOf(this.fRedundantUpdates)));
        }
        if (this.fFailOnRedundantLabelUpdates && !this.fRedundantLabelUpdates.isEmpty()) {
            Assert.fail((String)("Redundant Label Updates: " + String.valueOf(this.fRedundantLabelUpdates)));
        }
        if (this.fFailOnMultipleLabelUpdateSequences && this.fLabelUpdatesComplete > this.fLabelUpdatesCompleteAtReset + 1) {
            Assert.fail((String)"Multiple label update sequences detected");
        }
        if (this.fFailOnMultipleModelUpdateSequences && this.fViewerUpdatesComplete > this.fViewerUpdatesCompleteAtReset + 1) {
            Assert.fail((String)"Multiple viewer update sequences detected");
        }
        if ((flags & 1) != 0 && (this.fLabelUpdatesComplete == this.fLabelUpdatesCompleteAtReset || this.fLabelUpdatesComplete != this.fLabelUpdatesStarted)) {
            return false;
        }
        if ((flags & 0x40000) != 0 && this.fLabelUpdatesStarted == this.fLabelUpdatesStartedAtReset) {
            return false;
        }
        if ((flags & 4) != 0 && !this.fLabelUpdates.isEmpty()) {
            return false;
        }
        if ((flags & 0x20000) != 0 && this.fViewerUpdatesStarted == this.fViewerUpdatesStartedAtReset) {
            return false;
        }
        if ((flags & 2) != 0 && (this.fViewerUpdatesComplete == this.fViewerUpdatesCompleteAtReset || this.fViewerUpdatesStarted != this.fViewerUpdatesComplete)) {
            return false;
        }
        if ((flags & 0x80000) != 0 && this.fHasChildrenUpdatesRunning.isEmpty() && this.fHasChildrenUpdatesCompleted.isEmpty()) {
            return false;
        }
        if ((flags & 8) != 0 && !this.fHasChildrenUpdatesScheduled.isEmpty()) {
            return false;
        }
        if ((flags & 0x100000) != 0 && this.fChildCountUpdatesRunning.isEmpty() && this.fChildCountUpdatesCompleted.isEmpty()) {
            return false;
        }
        if ((flags & 0x10) != 0 && !this.fChildCountUpdatesScheduled.isEmpty()) {
            return false;
        }
        if ((flags & 0x200000) != 0 && this.fChildrenUpdatesRunning.isEmpty() && this.fChildrenUpdatesCompleted.isEmpty()) {
            return false;
        }
        if ((flags & 0x400000) != 0 && !this.isFinishedChildrenRunning()) {
            return false;
        }
        if ((flags & 0x20) != 0 && !this.fChildrenUpdatesScheduled.isEmpty()) {
            return false;
        }
        if ((flags & 0x40) != 0 && !this.fModelChangedComplete) {
            return false;
        }
        if ((flags & 0x100) != 0 && !this.fStateSaveComplete) {
            return false;
        }
        if ((flags & 0x1000000) != 0 && !this.fStateSaveStarted) {
            return false;
        }
        if ((flags & 0x200) != 0 && !this.fStateRestoreComplete) {
            return false;
        }
        if ((flags & 0x2000000) != 0 && !this.fStateRestoreStarted) {
            return false;
        }
        if ((flags & 0x400) != 0 && !this.fStateUpdates.isEmpty()) {
            return false;
        }
        if ((flags & 0x80) != 0 && !this.fProxyModels.isEmpty()) {
            return false;
        }
        if ((flags & 0x1000) != 0 && this.fViewerUpdatesCounter != 0) {
            return false;
        }
        return (flags & 0x2000) == 0 || this.fLabelUpdatesCounter == 0;
    }

    private boolean isFinishedChildrenRunning() {
        int i;
        Set<Integer> set;
        int scheduledCount = 0;
        Iterator<Set<Integer>> itr = this.fChildrenUpdatesScheduled.values().iterator();
        while (itr.hasNext()) {
            scheduledCount += itr.next().size();
        }
        int runningCount = 0;
        for (IChildrenUpdate iChildrenUpdate : this.fChildrenUpdatesRunning) {
            set = this.fChildrenUpdatesScheduled.get(iChildrenUpdate.getElementPath());
            i = iChildrenUpdate.getOffset();
            while (set != null && i < iChildrenUpdate.getOffset() + iChildrenUpdate.getLength()) {
                if (set.contains(i)) {
                    ++runningCount;
                }
                ++i;
            }
        }
        for (IChildrenUpdate iChildrenUpdate : this.fChildrenUpdatesCompleted) {
            set = this.fChildrenUpdatesScheduled.get(iChildrenUpdate.getElementPath());
            i = iChildrenUpdate.getOffset();
            while (set != null && i < iChildrenUpdate.getOffset() + iChildrenUpdate.getLength()) {
                if (set.contains(i)) {
                    ++runningCount;
                }
                ++i;
            }
        }
        return scheduledCount == runningCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStarted(IViewerUpdate update) {
        TestModelUpdatesListener testModelUpdatesListener = this;
        synchronized (testModelUpdatesListener) {
            ++this.fViewerUpdatesCounter;
            if (update instanceof IHasChildrenUpdate) {
                this.fHasChildrenUpdatesRunning.add(update);
            }
            if (update instanceof IChildrenCountUpdate) {
                this.fChildCountUpdatesRunning.add(update);
            } else if (update instanceof IChildrenUpdate) {
                this.fChildrenUpdatesRunning.add(update);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComplete(IViewerUpdate update) {
        TestModelUpdatesListener testModelUpdatesListener = this;
        synchronized (testModelUpdatesListener) {
            --this.fViewerUpdatesCounter;
        }
        if (!update.isCanceled()) {
            TreePath updatePath = update.getElementPath();
            if (update instanceof IHasChildrenUpdate) {
                this.fHasChildrenUpdatesRunning.remove(update);
                this.fHasChildrenUpdatesCompleted.add(update);
                if (!this.fHasChildrenUpdatesScheduled.remove(updatePath) && this.fFailOnRedundantUpdates && this.fRedundantHasChildrenUpdateExceptions.contains(updatePath)) {
                    this.fRedundantUpdates.add(update);
                }
            }
            if (update instanceof IChildrenCountUpdate) {
                this.fChildCountUpdatesRunning.remove(update);
                this.fChildCountUpdatesCompleted.add(update);
                if (!this.fChildCountUpdatesScheduled.remove(updatePath) && this.fFailOnRedundantUpdates && !this.fRedundantChildCountUpdateExceptions.contains(updatePath)) {
                    this.fRedundantUpdates.add(update);
                }
            } else if (update instanceof IChildrenUpdate) {
                this.fChildrenUpdatesRunning.remove(update);
                this.fChildrenUpdatesCompleted.add(update);
                int start = ((IChildrenUpdate)update).getOffset();
                int end = start + ((IChildrenUpdate)update).getLength();
                Set<Integer> childrenIndexes = this.fChildrenUpdatesScheduled.get(updatePath);
                if (childrenIndexes != null) {
                    int i = start;
                    while (i < end) {
                        childrenIndexes.remove(i);
                        ++i;
                    }
                    if (childrenIndexes.isEmpty()) {
                        this.fChildrenUpdatesScheduled.remove(updatePath);
                    }
                } else if (this.fFailOnRedundantUpdates && this.fRedundantChildrenUpdateExceptions.contains(updatePath)) {
                    this.fRedundantUpdates.add(update);
                }
            }
        }
    }

    public void viewerUpdatesBegin() {
        if (this.fViewerUpdatesStarted > this.fViewerUpdatesComplete) {
            this.fFailExpectation = new RuntimeException("Unmatched updatesStarted/updateCompleted notifications observed.");
        }
        ++this.fViewerUpdatesStarted;
    }

    public void viewerUpdatesComplete() {
        if (this.fViewerUpdatesStarted <= this.fViewerUpdatesComplete) {
            this.fFailExpectation = new RuntimeException("Unmatched updatesStarted/updateCompleted notifications observed.");
        }
        ++this.fViewerUpdatesComplete;
    }

    public void labelUpdateComplete(ILabelUpdate update) {
        this.fLabelUpdatesRunning.remove(update);
        this.fLabelUpdatesCompleted.add(update);
        --this.fLabelUpdatesCounter;
        if (!this.fLabelUpdates.remove(update.getElementPath()) && this.fFailOnRedundantLabelUpdates && !this.fRedundantLabelUpdateExceptions.contains(update.getElementPath())) {
            this.fRedundantLabelUpdates.add(update);
            Assert.fail((String)("Redundant update: " + String.valueOf(update)));
        }
    }

    public void labelUpdateStarted(ILabelUpdate update) {
        this.fLabelUpdatesRunning.add(update);
        ++this.fLabelUpdatesCounter;
    }

    public void labelUpdatesBegin() {
        if (this.fLabelUpdatesStarted > this.fLabelUpdatesComplete) {
            this.fFailExpectation = new RuntimeException("Unmatched labelUpdatesStarted/labelUpdateCompleted notifications observed.");
        }
        ++this.fLabelUpdatesStarted;
    }

    public void labelUpdatesComplete() {
        if (this.fLabelUpdatesStarted <= this.fLabelUpdatesComplete) {
            this.fFailExpectation = new RuntimeException("Unmatched labelUpdatesStarted/labelUpdateCompleted notifications observed.");
        }
        ++this.fLabelUpdatesComplete;
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        this.fModelChangedComplete = true;
        Iterator<TestModel> itr = this.fProxyModels.iterator();
        while (itr.hasNext()) {
            TestModel model = itr.next();
            if (model.getModelProxy() != proxy) continue;
            itr.remove();
            break;
        }
    }

    public void stateRestoreUpdatesBegin(Object input) {
        if (this.fExpectRestoreAfterSaveComplete && !this.fStateSaveComplete) {
            this.fFailExpectation = new RuntimeException("RESTORE should begin after SAVE completed!");
        }
        this.fStateRestoreStarted = true;
    }

    public void stateRestoreUpdatesComplete(Object input) {
        Assert.assertFalse((String)"RESTORE STATE already complete!", (boolean)this.fStateRestoreComplete);
        this.fStateRestoreComplete = true;
    }

    public void stateSaveUpdatesBegin(Object input) {
        this.fStateSaveStarted = true;
    }

    public void stateSaveUpdatesComplete(Object input) {
        this.fStateSaveComplete = true;
    }

    public void stateUpdateComplete(Object input, IViewerUpdate update) {
        if (!(update instanceof ElementCompareRequest) || ((ElementCompareRequest)update).isEqual()) {
            this.fStateUpdates.remove(update.getElementPath());
        }
    }

    public void stateUpdateStarted(Object input, IViewerUpdate update) {
    }

    private String toString(int flags) {
        StringBuilder buf = new StringBuilder("Viewer Update Listener");
        if (this.fJobError != null) {
            buf.append("\n\t");
            buf.append("fJobError = " + String.valueOf(this.fJobError));
            if (this.fJobError.getException() != null) {
                StackTraceElement[] trace;
                StackTraceElement[] stackTraceElementArray = trace = this.fJobError.getException().getStackTrace();
                int n = trace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement t = stackTraceElementArray[n2];
                    buf.append("\n\t\t");
                    buf.append(t);
                    ++n2;
                }
            }
        }
        if (this.fFailOnRedundantUpdates) {
            buf.append("\n\t");
            buf.append("fRedundantUpdates = " + String.valueOf(this.fRedundantUpdates));
        }
        if ((flags & 1) != 0) {
            buf.append("\n\t");
            buf.append("fLabelUpdatesComplete = " + this.fLabelUpdatesComplete);
            buf.append("\n\t");
            buf.append("fLabelUpdatesCompleteAtReset = ");
            buf.append(this.fLabelUpdatesCompleteAtReset);
        }
        if ((flags & 0x2000) != 0) {
            buf.append("\n\t");
            buf.append("fLabelUpdatesRunning = " + this.fLabelUpdatesCounter);
        }
        if ((flags & 0x40000) != 0) {
            buf.append("\n\t");
            buf.append("fLabelUpdatesStarted = ");
            buf.append(this.fLabelUpdatesStarted);
            buf.append("\n\t");
            buf.append("fLabelUpdatesCompleted = ");
            buf.append(this.fLabelUpdatesCompleted);
        }
        if ((flags & 4) != 0) {
            buf.append("\n\t");
            buf.append("fLabelUpdates = ");
            buf.append(this.toString(this.fLabelUpdates));
        }
        if ((flags & 0x1000) != 0) {
            buf.append("\n\t");
            buf.append("fViewerUpdatesStarted = " + this.fViewerUpdatesStarted);
            buf.append("\n\t");
            buf.append("fViewerUpdatesRunning = " + this.fViewerUpdatesCounter);
        }
        if ((flags & 2) != 0) {
            buf.append("\n\t");
            buf.append("fViewerUpdatesComplete = " + this.fViewerUpdatesComplete);
            buf.append("\n\t");
            buf.append("fViewerUpdatesCompleteAtReset = " + this.fViewerUpdatesCompleteAtReset);
        }
        if ((flags & 0x80000) != 0) {
            buf.append("\n\t");
            buf.append("fHasChildrenUpdatesRunning = ");
            buf.append(this.fHasChildrenUpdatesRunning);
            buf.append("\n\t");
            buf.append("fHasChildrenUpdatesCompleted = ");
            buf.append(this.fHasChildrenUpdatesCompleted);
        }
        if ((flags & 8) != 0) {
            buf.append("\n\t");
            buf.append("fHasChildrenUpdates = ");
            buf.append(this.toString(this.fHasChildrenUpdatesScheduled));
        }
        if ((flags & 0x100000) != 0) {
            buf.append("\n\t");
            buf.append("fChildCountUpdatesRunning = ");
            buf.append(this.fChildCountUpdatesRunning);
            buf.append("\n\t");
            buf.append("fChildCountUpdatesCompleted = ");
            buf.append(this.fChildCountUpdatesCompleted);
        }
        if ((flags & 0x10) != 0) {
            buf.append("\n\t");
            buf.append("fChildCountUpdates = ");
            buf.append(this.toString(this.fChildCountUpdatesScheduled));
        }
        if ((flags & 0x200000) != 0) {
            buf.append("\n\t");
            buf.append("fChildrenUpdatesRunning = ");
            buf.append(this.fChildrenUpdatesRunning);
            buf.append("\n\t");
            buf.append("fChildrenUpdatesCompleted = ");
            buf.append(this.fChildrenUpdatesCompleted);
        }
        if ((flags & 0x20) != 0) {
            buf.append("\n\t");
            buf.append("fChildrenUpdates = ");
            buf.append(this.toString(this.fChildrenUpdatesScheduled));
        }
        if ((flags & 0x40) != 0) {
            buf.append("\n\t");
            buf.append("fModelChangedComplete = " + this.fModelChangedComplete);
        }
        if ((flags & 0x100) != 0) {
            buf.append("\n\t");
            buf.append("fStateSaveComplete = " + this.fStateSaveComplete);
        }
        if ((flags & 0x200) != 0) {
            buf.append("\n\t");
            buf.append("fStateRestoreComplete = " + this.fStateRestoreComplete);
        }
        if ((flags & 0x80) != 0) {
            buf.append("\n\t");
            buf.append("fProxyModels = " + String.valueOf(this.fProxyModels));
        }
        if ((flags & 0x400) != 0) {
            buf.append("\n\t");
            buf.append("fStateUpdates = " + this.toString(this.fStateUpdates));
        }
        if (this.fTimeoutInterval > 0) {
            buf.append("\n\t");
            buf.append("fTimeoutInterval = " + this.fTimeoutInterval);
        }
        if (this.fTimeoutTime < System.currentTimeMillis()) {
            buf.append("\n\t");
            buf.append("fTimeoutTime = " + this.fTimeoutTime);
            buf.append("Current Time = " + System.currentTimeMillis());
        }
        return buf.toString();
    }

    private String toString(Set<TreePath> set) {
        if (set.isEmpty()) {
            return "(EMPTY)";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<TreePath> itr = set.iterator();
        while (itr.hasNext()) {
            buf.append("\n\t\t");
            buf.append(this.toString(itr.next()));
        }
        return buf.toString();
    }

    private String toString(Map<TreePath, Set<Integer>> map) {
        if (map.isEmpty()) {
            return "(EMPTY)";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<TreePath> itr = map.keySet().iterator();
        while (itr.hasNext()) {
            buf.append("\n\t\t");
            TreePath path = itr.next();
            buf.append(this.toString(path));
            Set<Integer> updates = map.get(path);
            buf.append(" = ");
            buf.append(updates.toString());
        }
        return buf.toString();
    }

    private String toString(TreePath path) {
        if (path.getSegmentCount() == 0) {
            return "/";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < path.getSegmentCount()) {
            buf.append("/");
            buf.append(path.getSegment(i));
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(3946495);
    }
}

