/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.TreePath;
import org.junit.Assert;
import org.junit.Test;

public abstract class UpdateTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, false, false);
    }

    @Test
    public void testRemoveElements() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        TestModel.TestElement root = model.getRootElement();
        TreePath rootPath = new TreePath(new Object[0]);
        TestModel.TestElement[] newElements = new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0]), new TestModel.TestElement(model, "3", new TestModel.TestElement[0])};
        model.setElementChildren(rootPath, newElements);
        this.fListener.reset(rootPath, root, -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)root, 1024));
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    @Test
    public void testAddNewChildren() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = model.getRootElement().getChildren()[0];
        TreePath elementPath = new TreePath(new Object[]{element});
        TestModel.TestElement[] newChildren = new TestModel.TestElement[]{new TestModel.TestElement(model, "1.1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.2", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.3", new TestModel.TestElement[0])};
        model.setElementChildren(elementPath, newChildren);
        TreePath rootPath = TreePath.EMPTY;
        TestModel.TestElement rootElement = model.getRootElement();
        this.fListener.reset(rootPath, rootElement, -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)rootElement, 1024));
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    private void removeElement(TestModel model, int index, boolean validate) throws Exception {
        ModelDelta delta = model.removeElementChild(TreePath.EMPTY, index);
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        if (validate) {
            model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        }
    }

    private void addElement(TestModel model, String label, int position, boolean validate) throws Exception {
        ModelDelta delta = model.addElementChild(TreePath.EMPTY, null, position, new TestModel.TestElement(model, label, new TestModel.TestElement[0]));
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        if (validate) {
            this.waitWhile(t -> !this.fListener.isFinished(67), this.createListenerErrorMessage());
            model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        } else {
            this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        }
    }

    private void insertElement(TestModel model, String label, int position, boolean validate) throws Exception {
        ModelDelta delta = model.insertElementChild(TreePath.EMPTY, position, new TestModel.TestElement(model, label, new TestModel.TestElement[0]));
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        if (validate) {
            this.waitWhile(t -> !this.fListener.isFinished(67), this.createListenerErrorMessage());
            model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        } else {
            this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        }
    }

    @Test
    public void testRepeatedAddRemoveElement() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        this.removeElement(model, 2, true);
        this.addElement(model, "3-new", 3, true);
        this.removeElement(model, 4, true);
        this.addElement(model, "5-new", 5, true);
        this.removeElement(model, 1, true);
        this.addElement(model, "1-new", 1, true);
        this.removeElement(model, 3, true);
        this.addElement(model, "4-new", 4, true);
    }

    @Test
    public void testNotifyUpdatesTartedOnModelChanged() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        this.fListener.reset();
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        Assert.assertTrue((boolean)this.fListener.isFinished(131072));
    }

    @Test
    public void testContentPlusAddRemoveUpdateRaceConditionsElement() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        TestModelUpdatesListener childrenCountUpdateListener = new TestModelUpdatesListener((ITreeModelViewer)this.fViewer, false, false);
        int i = 0;
        while (i < 10) {
            String pass = "pass #" + i;
            childrenCountUpdateListener.reset();
            childrenCountUpdateListener.addChildreCountUpdate(TreePath.EMPTY);
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
            this.removeElement(model, 5, false);
            this.removeElement(model, 4, false);
            this.removeElement(model, 3, false);
            this.removeElement(model, 2, false);
            this.removeElement(model, 1, false);
            this.removeElement(model, 0, false);
            this.waitWhile(t -> !childrenCountUpdateListener.isFinished(16), this.createListenerErrorMessage());
            this.insertElement(model, "1 - " + pass, 0, false);
            this.insertElement(model, "2 - " + pass, 1, false);
            this.insertElement(model, "3 - " + pass, 2, false);
            this.insertElement(model, "4 - " + pass, 3, false);
            this.insertElement(model, "5 - " + pass, 4, false);
            this.insertElement(model, "6 - " + pass, 5, false);
            this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
            model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
            ++i;
        }
        childrenCountUpdateListener.dispose();
    }

    @Test
    public void testInsertAtInvalidIndex() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        int insertIndex = model.getRootElement().getChildren().length;
        ModelDelta delta = model.insertElementChild(TreePath.EMPTY, insertIndex, new TestModel.TestElement(model, "last - invalid index", new TestModel.TestElement[0]));
        delta.accept((visitorDelta, depth) -> {
            if ((visitorDelta.getFlags() & 0x10) != 0) {
                ((ModelDelta)visitorDelta).setIndex(insertIndex + 1);
                return false;
            }
            return true;
        });
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(67), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    @Test
    public void testRescheduleUpdates() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        int i = 0;
        while (i < 5) {
            TestModel.TestElement rootElement = model.getRootElement();
            this.fListener.reset();
            this.fListener.addUpdates(TreePath.EMPTY, model.getRootElement(), 1, 16);
            model.postDelta((IModelDelta)new ModelDelta((Object)rootElement, 1024));
            this.waitWhile(t -> !this.fListener.isFinished(0x200050), this.createListenerErrorMessage());
            this.removeElement(model, 0, true);
            this.addElement(model, "1", 0, true);
            ++i;
        }
    }

    @Test
    public void testCanceledUpdates1() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            this.waitWhile(t -> !this.fListener.isFinished(0x100040), this.createListenerErrorMessage());
            ++i;
        }
        model.setQeueueingUpdate(false);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
    }

    @Test
    public void testCanceledUpdates2() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            this.waitWhile(t -> !this.fListener.isFinished(0x100040), this.createListenerErrorMessage());
            ++i;
        }
        ArrayList<IViewerUpdate> updates = new ArrayList<IViewerUpdate>(model.getQueuedUpdates());
        model.getQueuedUpdates().clear();
        int i2 = updates.size() - 1;
        while (i2 >= 0) {
            model.processUpdate(updates.get(i2));
            --i2;
        }
        model.setQeueueingUpdate(false);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
    }

    @Test
    public void testCanceledUpdates3() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            long start = System.currentTimeMillis();
            while (!this.fListener.isFinished(0x200040) && System.currentTimeMillis() - start < this.testTimeout) {
                this.completeQueuedUpdatesOfType(model, IChildrenCountUpdate.class);
                this.completeQueuedUpdatesOfType(model, IHasChildrenUpdate.class);
                TestUtil.processUIEvents();
            }
            ++i;
        }
        model.setQeueueingUpdate(false);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
    }

    @Test
    public void testCanceledUpdates4() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            long start = System.currentTimeMillis();
            while (!this.fListener.isFinished(0x200040) && System.currentTimeMillis() - start < this.testTimeout) {
                this.completeQueuedUpdatesOfType(model, IChildrenCountUpdate.class);
                this.completeQueuedUpdatesOfType(model, IHasChildrenUpdate.class);
                TestUtil.processUIEvents();
            }
            ++i;
        }
        ArrayList<IViewerUpdate> updates = new ArrayList<IViewerUpdate>(model.getQueuedUpdates());
        model.getQueuedUpdates().clear();
        int i2 = updates.size() - 1;
        while (i2 >= 0) {
            model.processUpdate(updates.get(i2));
            --i2;
        }
        model.setQeueueingUpdate(false);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
    }

    @Test
    public void testCancelUpdatesOnRemoveElementWhileUpdatingSubTree() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        this.fListener.reset();
        TreePath path = model.findElement("2");
        this.fListener.addUpdates(path, model.getElement(path), 1, 16);
        this.fListener.addChildreUpdate(path, 0);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(0x400050), this.createListenerErrorMessage());
        this.removeElement(model, 1, true);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
    }

    @Test
    public void testCanceledUpdatesOnSetInput() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(false);
        this.fListener.reset();
        this.fListener.addChildreCountUpdate(TreePath.EMPTY);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(80), this.createListenerErrorMessage());
        TestModel model2 = new TestModel();
        model2.setRoot(new TestModel.TestElement(model2, "root", new TestModel.TestElement[0]));
        this.fViewer.setInput((Object)model2.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(4154), this.createListenerErrorMessage());
    }

    @Test
    public void testCanceledUpdatesOnSetNullInput() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(false);
        this.fListener.reset();
        this.fListener.addChildreCountUpdate(TreePath.EMPTY);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(80), this.createListenerErrorMessage());
        this.fViewer.setInput(null);
        this.waitWhile(t -> !this.fListener.isFinished(4154), this.createListenerErrorMessage());
    }

    private void completeQueuedUpdatesOfType(TestModel model, Class<?> updateClass) {
        LinkedList<IViewerUpdate> updatesToComplete = new LinkedList<IViewerUpdate>();
        Iterator<Object> itr = model.getQueuedUpdates().iterator();
        while (itr.hasNext()) {
            IViewerUpdate update = itr.next();
            if (!updateClass.isInstance(update)) continue;
            updatesToComplete.add(update);
            itr.remove();
        }
        if (updatesToComplete != null) {
            itr = updatesToComplete.iterator();
            while (itr.hasNext()) {
                model.processUpdate((IViewerUpdate)itr.next());
            }
        }
    }
}

