/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Directory;
import org.eclipse.equinox.internal.p2.discovery.compatibility.DirectoryParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DirectoryParserTest {
    private DirectoryParser parser;

    @Before
    public void setUp() {
        this.parser = new DirectoryParser();
    }

    @Test
    public void testParse() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)"http://foo.bar.nodomain/baz.jar", (Object)((Directory.Entry)directory.getEntries().get(0)).getLocation());
    }

    @Test
    public void testParseBadFormat() {
        try {
            this.parser.parse((Reader)new StringReader("<directory2 xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory2>"));
            Assert.fail((String)"Expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testParseMalformed() {
        try {
            this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\">"));
            Assert.fail((String)"Expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testParseUnexpectedElementsAndAttributes() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" id=\"asdf\"><baz/></entry><foo/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)"http://foo.bar.nodomain/baz.jar", (Object)((Directory.Entry)directory.getEntries().get(0)).getLocation());
    }

    @Test
    public void testParseNoNS() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)"http://foo.bar.nodomain/baz.jar", (Object)((Directory.Entry)directory.getEntries().get(0)).getLocation());
    }

    @Test
    public void testParsePermitCategoriesTrue() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"true\"/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)true, (Object)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    @Test
    public void testParsePermitCategoriesFalse() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"false\"/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)false, (Object)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    @Test
    public void testParsePermitCategoriesNotSpecified() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)false, (Object)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    @Test
    public void testParsePermitCategoriesSpecifiedBadly() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"\"/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)false, (Object)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    @Test
    public void testParsePermitCategoriesSpecifiedBadly2() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"asdf\"/></directory>"));
        Assert.assertNotNull((Object)directory);
        Assert.assertEquals((long)1L, (long)directory.getEntries().size());
        Assert.assertEquals((Object)false, (Object)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }
}

