/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.discovery.compatibility.RemoteBundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.discovery.tests.DiscoveryTestConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoteBundleDiscoveryStrategyTest {
    private RemoteBundleDiscoveryStrategy discoveryStrategy;

    @Before
    public void setUp() throws Exception {
        this.discoveryStrategy = new RemoteBundleDiscoveryStrategy();
        this.discoveryStrategy.setDirectoryUrl(DiscoveryTestConstants.DISCOVERY_URL);
        this.discoveryStrategy.setCategories(new ArrayList());
        this.discoveryStrategy.setItems(new ArrayList());
        this.discoveryStrategy.setCertifications(new ArrayList());
        this.discoveryStrategy.setTags(new ArrayList());
    }

    @Test
    public void testPerformDiscovery() throws CoreException, IOException {
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)this.discoveryStrategy.getCategories().isEmpty());
        for (CatalogCategory category : this.discoveryStrategy.getCategories()) {
            Assert.assertNotNull((Object)category.getId());
            Assert.assertNotNull((Object)category.getName());
            Assert.assertNotNull((Object)category.getDescription());
        }
        Assert.assertFalse((boolean)this.discoveryStrategy.getItems().isEmpty());
        for (CatalogItem connector : this.discoveryStrategy.getItems()) {
            Assert.assertNotNull((Object)connector.getId());
            Assert.assertNotNull((Object)connector.getTags());
            Assert.assertNotNull((Object)connector.getName());
            Assert.assertNotNull((Object)connector.getDescription());
            Assert.assertNotNull((Object)connector.getSource());
            URL pluginXmlUrl = connector.getSource().getResource("plugin.xml");
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream in = pluginXmlUrl.openStream();){
                Assert.assertNotNull((Object)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

