/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core.mock;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.discovery.tests.core.mock.CatalogCategoryMockFactory;
import org.eclipse.equinox.p2.discovery.tests.core.mock.CatalogItemMockFactory;

public class MockDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private int connectorCount = 15;
    private int categoryCount = 5;
    protected CatalogItemMockFactory connectorMockFactory = new CatalogItemMockFactory();
    protected CatalogCategoryMockFactory categoryMockFactory = new CatalogCategoryMockFactory();

    public void performDiscovery(IProgressMonitor monitor) {
        int x = 0;
        while (x < this.categoryCount) {
            CatalogCategory mockCategory = this.createDiscoveryCategory();
            this.getCategories().add(mockCategory);
            ++x;
        }
        x = 0;
        while (x < this.connectorCount) {
            CatalogItem mockConnector = this.createDiscoveryConnector();
            if (!this.getCategories().isEmpty()) {
                int categoryIndex = x % this.getCategories().size();
                mockConnector.setCategoryId(((CatalogCategory)this.getCategories().get(categoryIndex)).getId());
            }
            this.getItems().add(mockConnector);
            ++x;
        }
    }

    protected CatalogCategory createDiscoveryCategory() {
        return (CatalogCategory)this.categoryMockFactory.get();
    }

    protected CatalogItem createDiscoveryConnector() {
        return (CatalogItem)this.connectorMockFactory.get();
    }

    public CatalogCategoryMockFactory getCategoryMockFactory() {
        return this.categoryMockFactory;
    }

    public void setCategoryMockFactory(CatalogCategoryMockFactory categoryMockFactory) {
        this.categoryMockFactory = categoryMockFactory;
    }

    public CatalogItemMockFactory getConnectorMockFactory() {
        return this.connectorMockFactory;
    }

    public void setConnectorMockFactory(CatalogItemMockFactory connectorMockFactory) {
        this.connectorMockFactory = connectorMockFactory;
    }

    public int getConnectorCount() {
        return this.connectorCount;
    }

    public void setConnectorCount(int connectorCount) {
        this.connectorCount = connectorCount;
    }

    public int getCategoryCount() {
        return this.categoryCount;
    }

    public void setCategoryCount(int categoryCount) {
        this.categoryCount = categoryCount;
    }
}

