/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core.util;

import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.util.CatalogCategoryComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CatalogCategoryComparatorTest {
    private CatalogCategoryComparator comparator;
    private CatalogCategory category1;
    private CatalogCategory category2;

    @Before
    public void setUp() {
        this.comparator = new CatalogCategoryComparator();
        this.category1 = new CatalogCategory();
        this.category2 = new CatalogCategory();
    }

    @Test
    public void testSortByRelevanceInequal() {
        this.category1.setRelevance("100");
        this.category2.setRelevance("50");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.category1, this.category2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.category2, this.category1));
    }

    @Test
    public void testSortByRelevanceOneNotSpecified() {
        this.category1.setRelevance("10");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.category1, this.category2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.category2, this.category1));
    }

    @Test
    public void testSortByRelevanceSame() {
        this.category1.setRelevance("10");
        this.category1.setName("test");
        this.category1.setId("1");
        this.category2.setRelevance("10");
        this.category2.setName("test");
        this.category2.setId("1");
        Assert.assertEquals((long)0L, (long)this.comparator.compare(this.category1, this.category2));
        Assert.assertEquals((long)0L, (long)this.comparator.compare(this.category2, this.category1));
    }

    @Test
    public void testSortByRelevanceSameIdsDiffer() {
        this.category1.setRelevance("10");
        this.category1.setName("test");
        this.category1.setId("a");
        this.category2.setRelevance("10");
        this.category2.setName("test");
        this.category2.setId("b");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.category1, this.category2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.category2, this.category1));
    }

    @Test
    public void testSortByRelevanceSameNamesDiffer() {
        this.category1.setRelevance("10");
        this.category1.setName("a");
        this.category1.setId("a");
        this.category2.setRelevance("10");
        this.category2.setName("b");
        this.category2.setId("a");
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(this.category1, this.category2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(this.category2, this.category1));
    }
}

