/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core.util;

import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Group;
import org.eclipse.equinox.internal.p2.discovery.util.CatalogItemComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CatalogConnectorComparatorTest {
    private CatalogCategory category;
    private CatalogItemComparator comparator;

    @Before
    public void setUp() throws Exception {
        this.category = new CatalogCategory();
        this.comparator = new CatalogItemComparator();
    }

    private Group addGroup(String id) {
        Group group = new Group();
        group.setId(id);
        this.category.getGroup().add(group);
        return group;
    }

    private CatalogItem addConnectorDescriptor(String id, String name, String groupId) {
        CatalogItem connector = new CatalogItem();
        connector.setId(id);
        connector.setName(name);
        connector.setGroupId(groupId);
        connector.setCategory(this.category);
        this.category.getItems().add(connector);
        return connector;
    }

    @Test
    public void testOrderByGroup() {
        this.addGroup("1");
        this.addGroup("2");
        CatalogItem t1 = this.addConnectorDescriptor("b", "btest", "2");
        CatalogItem t2 = this.addConnectorDescriptor("a", "atest", "2");
        CatalogItem t3 = this.addConnectorDescriptor("c", "ctest", "1");
        CatalogItem t4 = this.addConnectorDescriptor("d", "dtest", "1");
        CatalogItem t5 = this.addConnectorDescriptor("0", "0test", null);
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t2, t1));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t1, t2));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t3, t4));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t4, t3));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t1, t5));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t5, t1));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t2, t5));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t5, t2));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t3, t5));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t5, t3));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t4, t5));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t5, t4));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t3, t1));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t1, t3));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t3, t2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t2, t3));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t4, t1));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t1, t4));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare(t4, t2));
        Assert.assertEquals((long)1L, (long)this.comparator.compare(t2, t4));
    }
}

