/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.tests.core.RepositoryProviderBic;
import org.eclipse.team.tests.core.RepositoryProviderNaish;
import org.eclipse.team.tests.core.RepositoryProviderWithLinking;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class RepositoryProviderTests {
    @Test
    public void testProvidersRegistered() throws CoreException, TeamException {
        ArrayList<String> repoProviderIds = new ArrayList<String>(Arrays.asList(RepositoryProvider.getAllProviderTypeIds()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)true, (Object)repoProviderIds.contains("org.eclipse.team.tests.core.bic-provider"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)true, (Object)repoProviderIds.contains("org.eclipse.team.tests.core.naish-provider"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)repoProviderIds.contains("org.eclipse.team.tests.core.other"));
    }

    @Test
    public void testGetProviderGeneric() throws CoreException, TeamException {
        IProject project = this.createTestProject("testGetProviderGeneric1");
        IProject project2 = this.createTestProject("testGetProviderGeneric2");
        boolean good = false;
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.other");
        }
        catch (TeamException e) {
            good = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)good);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.naish-provider");
        RepositoryProvider.map((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider");
        RepositoryProvider provider1 = RepositoryProvider.getProvider((IProject)project);
        RepositoryProvider provider2 = RepositoryProvider.getProvider((IProject)project2);
        org.junit.jupiter.api.Assertions.assertTrue((provider1 != null && provider1.getID().equals("org.eclipse.team.tests.core.naish-provider") ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((provider2 != null && provider2.getID().equals("org.eclipse.team.tests.core.naish-provider") ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((provider1.getProject().equals((Object)project) && provider2.getProject().equals((Object)project2) ? 1 : 0) != 0);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        provider1 = RepositoryProvider.getProvider((IProject)project);
        org.junit.jupiter.api.Assertions.assertTrue((provider1 != null && provider1.getID().equals("org.eclipse.team.tests.core.bic-provider") ? 1 : 0) != 0);
        IProject closedProject = this.createTestProject("testGetProviderGenericClosed");
        IProject nonExistantProject = ResourcesPlugin.getWorkspace().getRoot().getProject("nonExistant");
        closedProject.close(null);
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)closedProject));
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)nonExistantProject));
        RepositoryProvider.unmap((IProject)project);
        RepositoryProvider.unmap((IProject)project2);
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)project));
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)project2));
    }

    @Test
    public void testGetProviderById() throws CoreException, TeamException {
        IProject project1 = this.createTestProject("testGetProviderById_1");
        IProject project2 = this.createTestProject("testGetProviderById_2");
        RepositoryProvider.map((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProvider.map((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)RepositoryProvider.getProvider((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)RepositoryProvider.getProvider((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider"));
        IProject closedProject = this.createTestProject("testGetProviderGenericClosed");
        IProject nonExistantProject = ResourcesPlugin.getWorkspace().getRoot().getProject("nonExistant");
        closedProject.close(null);
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)closedProject, (String)"id"));
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)nonExistantProject, (String)"id"));
        RepositoryProvider.unmap((IProject)project1);
        RepositoryProvider.unmap((IProject)project2);
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider"));
        org.junit.jupiter.api.Assertions.assertNull((Object)RepositoryProvider.getProvider((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider"));
    }

    @Test
    public void testFileModificationValidator() throws CoreException, TeamException {
        IProject project = this.createTestProject("testFileModificationValidator");
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProviderBic bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)bicProvider));
        final boolean[] called = new boolean[1];
        bicProvider.setModificationValidator(new FileModificationValidator(){

            public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
                return null;
            }

            public IStatus validateSave(IFile file) {
                called[0] = true;
                return RepositoryProviderTests.getTeamTestStatus(0);
            }
        });
        IFile file = project.getFile("test.txt");
        file.create((InputStream)new ByteArrayInputStream("test".getBytes()), true, null);
        file.setContents((InputStream)new ByteArrayInputStream("test2".getBytes()), true, false, null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)called[0]);
        called[0] = false;
        bicProvider.setModificationValidator(new FileModificationValidator(){

            public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
                return null;
            }

            public IStatus validateSave(IFile file) {
                called[0] = true;
                return RepositoryProviderTests.getTeamTestStatus(4);
            }
        });
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> file.setContents((InputStream)new ByteArrayInputStream("test3".getBytes()), true, false, null), (String)"validate hook should veto this setContents");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)called[0]);
        bicProvider.setModificationValidator(null);
        file.setContents((InputStream)new ByteArrayInputStream("test4".getBytes()), true, false, null);
    }

    private static IStatus getTeamTestStatus(int severity) {
        return new Status(severity, "org.eclipse.team.tests.core", 0, "team status", null);
    }

    @Test
    public void testMoveDeleteHook() throws CoreException, TeamException {
        IProject project = this.createTestProject("testMoveDeleteHook");
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProviderBic bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)bicProvider));
        final boolean[] called = new boolean[6];
        IMoveDeleteHook hook = new IMoveDeleteHook(){

            public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
                called[0] = true;
                return false;
            }

            public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
                called[1] = true;
                return false;
            }

            public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
                called[2] = true;
                return false;
            }

            public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
                called[3] = true;
                return false;
            }

            public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
                called[4] = true;
                return false;
            }

            public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
                called[5] = true;
                return false;
            }
        };
        bicProvider.setMoveDeleteHook(hook);
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, (String[])new String[]{"deleteFile.txt", "moveFile.txt", "deletedFolder/", "moveFolder/"});
        ResourceTestUtil.createInWorkspace((IResource[])resources);
        resources[0].delete(false, null);
        resources[1].move(resources[1].getFullPath().removeLastSegments(1).append("movedFile_NEW"), false, null);
        resources[2].delete(false, null);
        resources[3].move(resources[3].getFullPath().removeLastSegments(1).append("movedFolder"), false, null);
        IProjectDescription desc = project.getDescription();
        desc.setName("movedProject");
        project.move(desc, false, null);
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject("movedProject");
        bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)newProject);
        bicProvider.setMoveDeleteHook(hook);
        newProject.delete(true, null);
        boolean[] blArray = called;
        int n = called.length;
        int n2 = 0;
        while (n2 < n) {
            boolean element = blArray[n2];
            org.junit.jupiter.api.Assertions.assertTrue((boolean)element);
            ++n2;
        }
    }

    @Test
    public void testMoveDeleteHookBetweenProjects() throws CoreException, TeamException {
        IProject projectA = this.createTestProject("testMoveDeleteHookBetweenProjects_A");
        IProject projectB = this.createTestProject("testMoveDeleteHookBetweenProjects_B");
        IProject projectC = this.createTestProject("testMoveDeleteHookBetweenProjects_C");
        RepositoryProvider.map((IProject)projectA, (String)"org.eclipse.team.tests.core.bic-provider");
        final RepositoryProviderBic bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)projectA, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProvider.map((IProject)projectB, (String)"org.eclipse.team.tests.core.naish-provider");
        RepositoryProviderNaish naishProvider = (RepositoryProviderNaish)RepositoryProvider.getProvider((IProject)projectB, (String)"org.eclipse.team.tests.core.naish-provider");
        org.junit.jupiter.api.Assertions.assertTrue((bicProvider != null && naishProvider != null ? 1 : 0) != 0);
        final boolean[] calledProjectA = new boolean[2];
        bicProvider.setMoveDeleteHook(new IMoveDeleteHook(){

            public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)bicProvider.getProject(), (Object)source.getProject());
                calledProjectA[0] = true;
                return false;
            }

            public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)bicProvider.getProject(), (Object)source.getProject());
                calledProjectA[1] = true;
                return false;
            }

            public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
                return false;
            }
        });
        final boolean[] calledProjectB = new boolean[2];
        naishProvider.setMoveDeleteHook(new IMoveDeleteHook(){

            public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)bicProvider.getProject(), (Object)destination.getProject());
                calledProjectB[0] = true;
                return false;
            }

            public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)bicProvider.getProject(), (Object)destination.getProject());
                calledProjectB[1] = true;
                return false;
            }

            public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
                return false;
            }
        });
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)projectA, (String[])new String[]{"moveFile.txt", "moveFolder/"});
        ResourceTestUtil.createInWorkspace((IResource[])resources);
        resources[0].move(projectB.getFullPath().append("moveFile_new.txt"), false, null);
        resources[1].move(projectB.getFullPath().append("movedFolder"), false, null);
        int i = 0;
        while (i < calledProjectA.length) {
            org.junit.jupiter.api.Assertions.assertTrue((calledProjectA[i] && !calledProjectB[i] ? 1 : 0) != 0);
            ++i;
        }
        calledProjectA[0] = false;
        calledProjectA[1] = false;
        calledProjectB[0] = false;
        calledProjectB[1] = false;
        resources = ResourceTestUtil.buildResources((IContainer)projectA, (String[])new String[]{"anotherMovedFiled.txt", "anotherMovedFolder/"});
        ResourceTestUtil.createInWorkspace((IResource[])resources);
        resources[0].move(projectC.getFullPath().append("moveFileOther_new.txt"), false, null);
        resources[1].move(projectC.getFullPath().append("movedFolderOther"), false, null);
        i = 0;
        while (i < calledProjectA.length) {
            org.junit.jupiter.api.Assertions.assertTrue((calledProjectA[i] && !calledProjectB[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testMapSuccess() throws CoreException, TeamException {
        IProject project = this.createTestProject("testLinkSuccess");
        IResource[] contents = ResourceTestUtil.buildResources((IContainer)project, (String[])new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        ResourceTestUtil.createInWorkspace((IResource[])contents);
        IFolder folder = project.getFolder("link");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        RepositoryProvider.unmap((IProject)project);
        folder.delete(false, null);
        folder = project.getFolder("link");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        RepositoryProvider.unmap((IProject)project);
        folder.delete(false, null);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
    }

    @Test
    public void testLinkSuccess() throws CoreException, TeamException {
        IProject project = this.createTestProject("testLinkSuccess");
        IResource[] contents = ResourceTestUtil.buildResources((IContainer)project, (String[])new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        ResourceTestUtil.createInWorkspace((IResource[])contents);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        IFolder folder = project.getFolder("link");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        folder.delete(false, null);
        folder = project.getFolder("link");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
    }

    @Test
    public void testMapFailure() throws CoreException, TeamException {
        IProject project = this.createTestProject("testMapFailure");
        IResource[] contents = ResourceTestUtil.buildResources((IContainer)project, (String[])new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        ResourceTestUtil.createInWorkspace((IResource[])contents);
        IFolder folder = project.getFolder("link");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(false);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        TeamException shallowLinkException = (TeamException)org.junit.jupiter.api.Assertions.assertThrows(TeamException.class, () -> RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking"), (String)"Link should be disallowed");
        Assertions.assertThat((int)shallowLinkException.getStatus().getCode()).isEqualTo(378);
        folder.delete(false, null);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        TeamException deepLinkException = (TeamException)org.junit.jupiter.api.Assertions.assertThrows(TeamException.class, () -> RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking"), (String)"Link should be disallowed");
        Assertions.assertThat((int)deepLinkException.getStatus().getCode()).isEqualTo(378);
        folder.delete(false, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(FileSystemHelper.getRandomLocation(), 16, null);
        TeamException shallowLinksAllowedException = (TeamException)org.junit.jupiter.api.Assertions.assertThrows(TeamException.class, () -> RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking"), (String)"Link should be disallowed");
        Assertions.assertThat((int)shallowLinksAllowedException.getStatus().getCode()).isEqualTo(378);
    }

    @Test
    public void testLinkFailure() throws CoreException, TeamException {
        IProject project = this.createTestProject("testLinkFailure");
        IResource[] contents = ResourceTestUtil.buildResources((IContainer)project, (String[])new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        ResourceTestUtil.createInWorkspace((IResource[])contents);
        RepositoryProviderWithLinking.setCanHandleLinking(false);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        IFolder folder = project.getFolder("link");
        CoreException shallowLinkException = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> folder.createLink(FileSystemHelper.getRandomLocation(), 16, null), (String)"Link should be disallowed");
        Assertions.assertThat((int)shallowLinkException.getStatus().getCode()).isEqualTo(378);
        IFolder innerFolder = project.getFolder("folder1/folder2");
        CoreException deepLinkException = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> innerFolder.createLink(FileSystemHelper.getRandomLocation(), 16, null), (String)"Link should be disallowed");
        Assertions.assertThat((int)deepLinkException.getStatus().getCode()).isEqualTo(378);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        CoreException shallowLinkAllowedException = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> innerFolder.createLink(FileSystemHelper.getRandomLocation(), 16, null), (String)"Link should be disallowed");
        Assertions.assertThat((int)shallowLinkAllowedException.getStatus().getCode()).isEqualTo(378);
    }

    @Test
    public void testIsShared() throws CoreException, TeamException {
        IProject project1 = this.createTestProject("testGetProviderById_1");
        RepositoryProvider.map((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)RepositoryProvider.isShared((IProject)project1));
        project1.close(null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)RepositoryProvider.isShared((IProject)project1));
        project1.open(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)RepositoryProvider.isShared((IProject)project1));
        RepositoryProvider.unmap((IProject)project1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)RepositoryProvider.isShared((IProject)project1));
    }

    private IProject createTestProject(String name) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        ResourceTestUtil.createInWorkspace((IResource)project);
        return project;
    }
}

