/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.team.internal.core.UserStringMappings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.service.prefs.BackingStoreException;

public final class UserMappingTest {
    private static final String KEY = "key";

    @Test
    public void testParsedCorrectly() {
        UserStringMappings mappings = this.mappings();
        Assertions.assertEquals((int)UserStringMappings.TEXT, (int)mappings.getType("*.ext"));
        Assertions.assertEquals((int)UserStringMappings.BINARY, (int)mappings.getType("*.bn"));
        Assertions.assertEquals((int)UserStringMappings.UNKNOWN, (int)mappings.getType("*.unkwn"));
        Assertions.assertEquals((int)UserStringMappings.UNKNOWN, (int)mappings.getType("someunknowntype"));
        Assertions.assertEquals((int)UserStringMappings.UNKNOWN, (int)mappings.getType(null));
    }

    @Test
    public void testPicksExternalChanges() throws BackingStoreException {
        UserStringMappings mappings = this.mappings();
        Assertions.assertEquals((int)UserStringMappings.UNKNOWN, (int)mappings.getType("some"));
        this.modify("some\n2\n");
        Assertions.assertEquals((int)UserStringMappings.BINARY, (int)mappings.getType("some"));
    }

    @Test
    public void testAcceptsCorruptedData() throws BackingStoreException {
        UserStringMappings mappings = this.mappings();
        Assertions.assertEquals((int)UserStringMappings.TEXT, (int)mappings.getType("*.ext"));
        this.modify("corrupted");
        Assertions.assertTrue((boolean)mappings.referenceMap().isEmpty());
    }

    private void modify(String value) throws BackingStoreException {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.team.core");
        node.put(KEY, value);
        node.flush();
    }

    private UserStringMappings mappings() {
        UserStringMappings mappings = new UserStringMappings(KEY);
        mappings.setStringMappings(new String[]{"*.ext", "*.bn", "*.unkwn"}, new int[]{UserStringMappings.TEXT, UserStringMappings.BINARY, UserStringMappings.UNKNOWN});
        return mappings;
    }
}

