/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.core.mapping.ResourceMappingScope;
import org.eclipse.team.ui.synchronize.ModelOperation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class ScopeBuildingTests {
    private static final RuntimeException PROMPT_EXCEPTION = new RuntimeException();
    protected static final String TEST_MODEL_PROVIDER_ID = "id1";

    private void expectPrompt(TestResourceMappingOperation op) {
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> op.run((IProgressMonitor)new NullProgressMonitor()));
        Assertions.assertSame((Object)PROMPT_EXCEPTION, (Object)exception, (String)"expected prompt did not occur");
    }

    private ResourceMapping getMapping(final IProject project, final IResource[] resources, final int depth) {
        return new ResourceMapping(){

            public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
                return new ResourceTraversal[]{new ResourceTraversal(resources, depth, 0)};
            }

            public IProject[] getProjects() {
                return new IProject[]{project};
            }

            public Object getModelObject() {
                return new Object();
            }

            public String getModelProviderId() {
                return ScopeBuildingTests.TEST_MODEL_PROVIDER_ID;
            }

            public boolean contains(ResourceMapping mapping) {
                return false;
            }
        };
    }

    @Test
    public void testAdditionalResources() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IResource[] contents = ResourceTestUtil.buildResources((IContainer)project, (String[])new String[]{"file.txt", "folder1/file2.txt", "folder1/folder2/file3.txt", "folder3/"});
        ResourceTestUtil.createInWorkspace((IResource[])contents);
        ResourceMapping[] mappings = new ResourceMapping[]{this.getMapping(project, new IResource[]{project.getFolder("folder1")}, 2)};
        ResourceMapping[] additionalMappings = new ResourceMapping[]{this.getMapping(project, new IResource[]{project.getFile("file.txt")}, 2)};
        TestResourceMappingOperation op = new TestResourceMappingOperation(mappings, additionalMappings);
        this.expectPrompt(op);
    }

    private class TestResourceMappingOperation
    extends ModelOperation {
        protected TestResourceMappingOperation(ResourceMapping[] selectedMappings, final ResourceMapping[] additionalMappings) {
            super(null, (ISynchronizationScopeManager)new SynchronizationScopeManager("", selectedMappings, ResourceMappingContext.LOCAL_CONTEXT, false){

                public void initialize(IProgressMonitor monitor) throws CoreException {
                    super.initialize(monitor);
                    ResourceMapping[] resourceMappingArray = additionalMappings;
                    int n = additionalMappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResourceMapping mapping = resourceMappingArray[n2];
                        ResourceTraversal[] traversals = mapping.getTraversals(this.getContext(), monitor);
                        ((ResourceMappingScope)this.getScope()).addMapping(mapping, traversals);
                        ++n2;
                    }
                }
            });
        }

        protected void endOperation(IProgressMonitor monitor) throws InvocationTargetException {
            ISynchronizationScopeManager manager = this.getScopeManager();
            manager.dispose();
            super.endOperation(monitor);
        }

        protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        }
    }
}

