/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core.mapping;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.tests.core.mapping.ScopeTestSubscriber;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class ScopeTests {
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IWorkingSet workingSet;
    private SubscriberScopeManager manager;

    @BeforeEach
    public void setUp() throws Exception {
        this.project1 = this.createProjectWithFile("p1", "file.txt");
        this.project2 = this.createProjectWithFile("p2", "file.txt");
        this.project3 = this.createProjectWithFile("p3", "file.txt");
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        this.workingSet = manager.createWorkingSet("TestWS", (IAdaptable[])new IProject[]{this.project1});
        manager.addWorkingSet(this.workingSet);
    }

    private IProject createProjectWithFile(String name, String fileName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace((IResource)project.getFile(fileName));
        return project;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.manager.dispose();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        manager.removeWorkingSet(this.workingSet);
    }

    private void assertProperContainment(ISynchronizationScopeManager sm) throws OperationCanceledException, InterruptedException {
        this.waitForManager(sm);
        this.testProjectContainment(sm, this.project1);
        this.testProjectContainment(sm, this.project2);
        this.testProjectContainment(sm, this.project3);
    }

    private void waitForManager(ISynchronizationScopeManager sm) throws OperationCanceledException, InterruptedException {
        Job.getJobManager().join((Object)sm, null);
    }

    private void testProjectContainment(ISynchronizationScopeManager sm, IProject project) {
        Assertions.assertFalse((this.isInWorkingSet(project) && !this.isInScope(sm, project) ? 1 : 0) != 0, (String)(project.getName() + " is in the working set but not in the scope"));
        Assertions.assertFalse((!this.isInWorkingSet(project) && this.isInScope(sm, project) ? 1 : 0) != 0, (String)(project.getName() + " is in scope but not in the working set"));
    }

    private boolean isInScope(ISynchronizationScopeManager sm, IProject project) {
        return sm.getScope().contains((IResource)project);
    }

    private boolean isInWorkingSet(IProject project) {
        IAdaptable[] elements;
        IAdaptable[] iAdaptableArray = elements = this.workingSet.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            if (adaptable.equals(project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ISynchronizationScopeManager createScopeManager() throws CoreException, OperationCanceledException, InterruptedException {
        ScopeTestSubscriber subscriber = new ScopeTestSubscriber();
        this.manager = new SubscriberScopeManager(subscriber.getName(), new ResourceMapping[]{Utils.getResourceMapping((Object)this.workingSet)}, (Subscriber)subscriber, true);
        this.manager.initialize((IProgressMonitor)new NullProgressMonitor());
        this.waitForManager((ISynchronizationScopeManager)this.manager);
        return this.manager;
    }

    @Test
    public void testScopeExpansion() throws CoreException, OperationCanceledException, InterruptedException {
        ISynchronizationScopeManager sm = this.createScopeManager();
        this.assertProperContainment(sm);
        this.workingSet.setElements((IAdaptable[])new IProject[]{this.project1, this.project2});
        this.assertProperContainment(sm);
    }

    @Test
    public void testScopeContraction() throws OperationCanceledException, InterruptedException, CoreException {
        this.workingSet.setElements((IAdaptable[])new IProject[]{this.project1, this.project2});
        ISynchronizationScopeManager sm = this.createScopeManager();
        this.assertProperContainment(sm);
        this.workingSet.setElements((IAdaptable[])new IProject[]{this.project1});
        this.assertProperContainment(sm);
    }
}

