/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core.regression;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.tests.core.regression.PessimisticRepositoryProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_217673 {
    @Test
    public void test() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        project.create(null);
        project.open(null);
        IFile resource = project.getFile(".project");
        IPath linkTarget = FileSystemHelper.getRandomLocation();
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.regression.pessimistic-provider");
            PessimisticRepositoryProvider.markWritableOnEdit = true;
            ResourceTestUtil.setReadOnly((IResource)resource, (boolean)true);
            linkTarget.toFile().mkdir();
            project.getFolder("test").createLink(linkTarget, 0, null);
            Assertions.assertFalse((boolean)this.isReadOnly((IResource)resource), (String)".project should no longer be read-only");
        }
        finally {
            PessimisticRepositoryProvider.markWritableOnEdit = false;
            RepositoryProvider.unmap((IProject)project);
            linkTarget.toFile().delete();
        }
    }

    private boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        return resourceAttributes.isReadOnly();
    }
}

