/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core.regression;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;

public class PessimisticRepositoryProvider
extends RepositoryProvider {
    public static final String NATURE_ID = "org.eclipse.team.tests.core.regression.pessimistic-provider";
    private FileModificationValidator validator = new WritabilityEnforcingFileModificationValidator();
    public static boolean markWritableOnEdit;
    public static boolean markWritableOnSave;

    public void configureProject() {
    }

    public String getID() {
        return NATURE_ID;
    }

    public void deconfigure() {
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public FileModificationValidator getFileModificationValidator2() {
        return this.validator;
    }

    private static void setReadOnly(IResource resource, boolean readOnly) throws CoreException {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes != null) {
            resourceAttributes.setReadOnly(readOnly);
            resource.setResourceAttributes(resourceAttributes);
        }
    }

    private static class WritabilityEnforcingFileModificationValidator
    extends FileModificationValidator {
        private WritabilityEnforcingFileModificationValidator() {
        }

        public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
            if (markWritableOnEdit) {
                try {
                    ResourcesPlugin.getWorkspace().run(monitor -> {
                        int i = 0;
                        int length = files.length;
                        while (i < length) {
                            try {
                                PessimisticRepositoryProvider.setReadOnly((IResource)files[i], false);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                    }, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return e.getStatus();
                }
            }
            return Status.OK_STATUS;
        }

        public IStatus validateSave(IFile file) {
            if (markWritableOnSave) {
                try {
                    PessimisticRepositoryProvider.setReadOnly((IResource)file, false);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return e.getStatus();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

