/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.tests.ReflectionUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SaveablesCompareEditorInput;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class SaveableCompareEditorInputTest {
    private static final String COMPARE_EDITOR = "org.eclipse.compare.CompareEditor";
    private IFile file1;
    private IFile file2;
    private final String appendFileContents = "_append";
    private final String fileContents1 = "FileContents";
    private final String fileContents2 = "FileContents2";
    private final TestLogListener logListener = new TestLogListener();
    private List<IStatus> errorsInListener = Collections.synchronizedList(new ArrayList());
    private IProject project;

    @BeforeEach
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        this.file1 = this.project.getFile("File1.txt");
        this.file2 = this.project.getFile("File2.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.file1);
        ResourceTestUtil.createInWorkspace((IResource)this.file2);
        this.file1.setContents(ResourceTestUtil.createInputStream((String)"FileContents"), true, true, null);
        this.file2.setContents(ResourceTestUtil.createInputStream((String)"FileContents2"), true, true, null);
        Platform.addLogListener((ILogListener)this.logListener);
    }

    @AfterEach
    public void tearDown() throws Exception {
        Platform.removeLogListener((ILogListener)this.logListener);
        ((ListAssert)Assertions.assertThat(this.errorsInListener).as("logged errors", new Object[0])).isEmpty();
    }

    private void verifyDirtyStateChanges(TestSaveableEditorInput compareEditorInput) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TextMergeViewer viewer = (TextMergeViewer)compareEditorInput.findContentViewer(null, compareEditorInput.input, (Composite)shell);
        viewer.setInput(compareEditorInput.getCompareResult());
        MergeSourceViewer left = (MergeSourceViewer)ReflectionUtils.getField((Object)viewer, (String)"fLeft");
        StyledText leftText = left.getSourceViewer().getTextWidget();
        leftText.append("_append");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)compareEditorInput.isDirty());
        viewer.flush(null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)compareEditorInput.isDirty());
    }

    @Test
    public void testDirtyFlagOnLocalResourceTypedElement() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        LocalResourceTypedElement el1 = (LocalResourceTypedElement)SaveableCompareEditorInput.createFileElement((IFile)this.file1);
        TestFileElement el2 = new TestFileElement(this.file2);
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput((ITypedElement)el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FileContents_append", (Object)this.file1.readString());
    }

    @Test
    public void testDirtyFlagOnCustomTypedElement() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        TestFileElement el1 = new TestFileElement(this.file1);
        TestFileElement el2 = new TestFileElement(this.file2);
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput(el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
    }

    @Test
    public void testDirtyFlagOnLocalResourceTypedElementAndEmptyRight() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        LocalResourceTypedElement el1 = (LocalResourceTypedElement)SaveableCompareEditorInput.createFileElement((IFile)this.file1);
        ITypedElement el2 = null;
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput((ITypedElement)el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FileContents_append", (Object)this.file1.readString());
    }

    @Test
    public void testDirtyFlagOnCustomTypedElementAndEmptyRight() throws CoreException, InvocationTargetException, InterruptedException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IOException {
        TestFileElement el1 = new TestFileElement(this.file1);
        ITypedElement el2 = null;
        CompareConfiguration conf = new CompareConfiguration();
        conf.setLeftEditable(true);
        TestSaveableEditorInput compareEditorInput = new TestSaveableEditorInput(el1, el2, conf);
        compareEditorInput.prepareCompareInput(null);
        this.verifyDirtyStateChanges(compareEditorInput);
    }

    private void verifyModifyAndSaveBothSidesOfCompareEditor(String extention) throws InterruptedException, InvocationTargetException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, CoreException, IOException {
        IFile file1 = this.project.getFile("CompareFile1." + extention);
        IFile file2 = this.project.getFile("CompareFile2." + extention);
        file1.create((InputStream)new ByteArrayInputStream("FileContents".getBytes()), true, null);
        file2.create((InputStream)new ByteArrayInputStream("FileContents2".getBytes()), true, null);
        SaveablesCompareEditorInput input = new SaveablesCompareEditorInput(null, SaveablesCompareEditorInput.createFileElement((IFile)file1), SaveablesCompareEditorInput.createFileElement((IFile)file2), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
        input.run(null);
        CompareEditor editor = (CompareEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, COMPARE_EDITOR, true);
        CompareViewerSwitchingPane pane = (CompareViewerSwitchingPane)ReflectionUtils.getField((Object)input, (String)"fContentInputPane", (boolean)true);
        Viewer viewer = pane.getViewer();
        MergeSourceViewer left = (MergeSourceViewer)ReflectionUtils.getField((Object)viewer, (String)"fLeft", (boolean)true);
        MergeSourceViewer right = (MergeSourceViewer)ReflectionUtils.getField((Object)viewer, (String)"fRight", (boolean)true);
        StyledText leftText = left.getSourceViewer().getTextWidget();
        StyledText rightText = right.getSourceViewer().getTextWidget();
        leftText.append("_append");
        rightText.append("_append");
        editor.doSave(null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)editor.isDirty());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FileContents_append", (Object)file1.readString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FileContents2_append", (Object)file2.readString());
    }

    @Test
    public void testModifyAndSaveBothSidesOfCompareEditorHtml() throws Exception {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("html");
    }

    @Test
    public void testModifyAndSaveBothSidesOfCompareEditorTxt() throws Exception {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("txt");
    }

    @Test
    public void testModifyAndSaveBothSidesOfCompareEditorJava() throws Exception {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("java");
    }

    @Test
    public void testModifyAndSaveBothSidesOfCompareEditorXml() throws Exception {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("xml");
    }

    @Test
    public void testModifyAndSaveBothSidesOfCompareEditorProperties() throws Exception {
        this.verifyModifyAndSaveBothSidesOfCompareEditor("properties");
    }

    private class TestDiffNode
    extends AbstractCompareInput {
        private final CompareInputChangeNotifier notifier;

        public TestDiffNode(ITypedElement left, ITypedElement right) {
            super(3, null, left, right);
            this.notifier = new CompareInputChangeNotifier(){

                private IResource getResource(ITypedElement el) {
                    if (el instanceof LocalResourceTypedElement) {
                        return ((LocalResourceTypedElement)el).getResource();
                    }
                    if (el instanceof TestFileElement) {
                        return ((TestFileElement)el).getFile();
                    }
                    return null;
                }

                protected IResource[] getResources(ICompareInput input) {
                    ArrayList<IResource> resources = new ArrayList<IResource>();
                    if (this.getResource(TestDiffNode.this.getLeft()) != null) {
                        resources.add(this.getResource(TestDiffNode.this.getLeft()));
                    }
                    if (this.getResource(TestDiffNode.this.getRight()) != null) {
                        resources.add(this.getResource(TestDiffNode.this.getRight()));
                    }
                    return resources.toArray(new IResource[2]);
                }
            };
        }

        public void fireChange() {
            super.fireChange();
        }

        protected CompareInputChangeNotifier getChangeNotifier() {
            return this.notifier;
        }

        public boolean needsUpdate() {
            return false;
        }

        public void update() {
            this.fireChange();
        }
    }

    private class TestFileElement
    implements ITypedElement {
        private final IFile file;

        public IFile getFile() {
            return this.file;
        }

        public TestFileElement(IFile file) {
            this.file = file;
        }

        public String getName() {
            return this.file.getName();
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }
    }

    private class TestLogListener
    implements ILogListener {
        private TestLogListener() {
        }

        public void logging(IStatus status, String plugin) {
            if (status.getSeverity() == 4) {
                SaveableCompareEditorInputTest.this.errorsInListener.add(status);
            }
        }
    }

    private class TestSaveableEditorInput
    extends SaveableCompareEditorInput {
        protected ITypedElement left;
        protected ITypedElement right;
        private ICompareInput input;

        public Object getCompareResult() {
            return this.input;
        }

        public TestSaveableEditorInput(ITypedElement left, ITypedElement right, CompareConfiguration conf) {
            super(conf, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
            this.left = left;
            this.right = right;
        }

        protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.input = this.createCompareInput();
            this.getCompareConfiguration().setLeftEditable(true);
            this.getCompareConfiguration().setRightEditable(false);
            return null;
        }

        private ICompareInput createCompareInput() {
            return new TestDiffNode(this.left, this.right);
        }

        protected void fireInputChange() {
            ((TestDiffNode)((Object)this.getCompareResult())).fireChange();
        }
    }
}

