/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ui.synchronize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.mapping.ResourceModelContentProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class ResourceContentTests {
    private ResourceModelContentProvider provider;

    @BeforeEach
    public void setUp() throws Exception {
        this.initializeProvider(null, null, null);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupProvider();
    }

    private void initializeProvider(ISynchronizationScope scope, ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
        this.cleanupProvider();
        this.provider = new TestableResourceModelContentProvider(scope, context, configuration);
    }

    private void cleanupProvider() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        this.provider = null;
    }

    private void assertContentMatches(IProject project, String[] leaves) {
        this.assertContentsMatch(this.asResources(project, leaves));
    }

    private void assertContentsMatch(IResource[] resources) {
        Set paths = this.getPaths(ResourcesPlugin.getWorkspace().getRoot());
        HashSet resourceSet = new HashSet();
        Collections.addAll(resourceSet, resources);
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            TreePath path = (TreePath)iterator.next();
            Object o = path.getLastSegment();
            if (!resourceSet.remove(o)) continue;
            iterator.remove();
        }
        Assertions.assertFalse((boolean)resourceSet.isEmpty(), (String)("Tree entries were missing for " + this.toString(resourceSet)));
        Assertions.assertFalse((boolean)paths.isEmpty(), (String)("Tree entries were found for " + this.toString(paths)));
    }

    private Set getPaths(Object root) {
        Object[] elements;
        HashSet result = new HashSet();
        Object[] objectArray = elements = this.provider.getElements(root);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            TreePath path = new TreePath(new Object[]{object});
            Set childPaths = this.getPaths(this.provider, path);
            result.addAll(childPaths);
            ++n2;
        }
        return result;
    }

    private Set getPaths(ResourceModelContentProvider provider, TreePath path) {
        Object[] children = provider.getChildren(path);
        HashSet<TreePath> result = new HashSet<TreePath>();
        if (children.length == 0) {
            result.add(path);
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            TreePath childPath = path.createChildPath(object);
            Set childPaths = this.getPaths(provider, childPath);
            result.addAll(childPaths);
            ++n2;
        }
        return result;
    }

    private String toString(Set set) {
        StringBuilder buffer = new StringBuilder();
        boolean addComma = false;
        for (Object resource : set) {
            buffer.append(this.toString(resource));
            if (addComma) {
                buffer.append(", ");
            }
            addComma = true;
        }
        return buffer.toString();
    }

    private String toString(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getFullPath().toString();
        }
        if (object instanceof TreePath) {
            return this.toString(((TreePath)object).getLastSegment());
        }
        return object.toString();
    }

    private IResource[] asResources(IProject project, String[] resourcePaths) {
        ArrayList<Object> resources = new ArrayList<Object>();
        String[] stringArray = resourcePaths;
        int n = resourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.endsWith("/")) {
                resources.add(project.getFolder(path));
            } else {
                resources.add(project.getFile(path));
            }
            ++n2;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    @Test
    public void testFileContent() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String[] files = new String[]{"file.txt", "file2.txt", "folder1/file3.txt", "folder1/folder2/file4.txt"};
        ResourceTestUtil.buildResources((IContainer)project, (String[])files);
        this.assertContentMatches(project, files);
    }

    public static class TestableResourceModelContentProvider
    extends ResourceModelContentProvider {
        private final ISynchronizationScope scope;
        private final ISynchronizationContext context;
        private final ISynchronizePageConfiguration configuration;

        public TestableResourceModelContentProvider(ISynchronizationScope scope, ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
            this.scope = scope;
            this.context = context;
            this.configuration = configuration;
        }

        public ISynchronizePageConfiguration getConfiguration() {
            return this.configuration;
        }

        public ISynchronizationContext getContext() {
            return this.context;
        }

        public ISynchronizationScope getScope() {
            return this.scope;
        }
    }
}

