/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.testbase;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.http.servlet.tests.bundle.BundleAdvisor;
import org.eclipse.equinox.http.servlet.tests.bundle.BundleInstaller;
import org.eclipse.equinox.http.servlet.tests.util.ServletRequestAdvisor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class BaseTest {
    public static final String DEFAULT = "default";
    final AtomicLong httpRuntimeChangeCount = new AtomicLong(-1L);
    protected static final String PROTOTYPE = "prototype/";
    protected static final String CONFIGURE = "configure";
    protected static final String UNREGISTER = "unregister";
    protected static final String ERROR = "error";
    protected static final String STATUS_PARAM = "servlet.init.status";
    protected static final String TEST_PROTOTYPE_NAME = "test.prototype.name";
    protected static final String TEST_PATH_CUSTOMIZER_NAME = "test.path.customizer.name";
    protected static final String TEST_ERROR_CODE = "test.error.code";
    protected static final String EQUINOX_DS_BUNDLE = "org.apache.felix.scr";
    protected static final String EQUINOX_JETTY_BUNDLE = "org.eclipse.equinox.http.jetty";
    protected static final String JETTY_PROPERTY_PREFIX = "org.eclipse.equinox.http.jetty.";
    protected static final String OSGI_HTTP_PORT_PROPERTY = "org.osgi.service.http.port";
    protected static final String STATUS_OK = "OK";
    protected static final String TEST_BUNDLES_BINARY_DIRECTORY = "/bundles_bin/";
    protected static final String TEST_BUNDLE_1 = "tb1";
    protected static final String TEST_BUNDLE_2 = "tb2";
    protected static final String[] BUNDLES = new String[]{"org.apache.felix.scr"};
    protected BundleInstaller installer;
    protected BundleAdvisor advisor;
    protected ServletRequestAdvisor requestAdvisor;
    protected final Collection<ServiceRegistration<? extends Object>> registrations = new ArrayList<ServiceRegistration<? extends Object>>();
    protected ServiceTracker<HttpServiceRuntime, ServiceReference<HttpServiceRuntime>> runtimeTracker;

    @Before
    public void setUp() throws Exception {
        System.setProperty("log.LEVEL", "OFF");
        System.setProperty("org.eclipse.jetty.server.LEVEL", "OFF");
        System.setProperty("org.eclipse.jetty.servlet.LEVEL", "OFF");
        System.setProperty(OSGI_HTTP_PORT_PROPERTY, "0");
        System.setProperty("org.eclipse.equinox.http.jetty.context.sessioninactiveinterval", "1");
        System.setProperty("org.eclipse.equinox.http.jetty.housekeeper.interval", "10");
        BundleContext bundleContext = this.getBundleContext();
        this.installer = new BundleInstaller(TEST_BUNDLES_BINARY_DIRECTORY, bundleContext);
        this.advisor = new BundleAdvisor(bundleContext);
        this.stopJetty();
        this.startBundles();
        this.runtimeTracker = new ServiceTracker(bundleContext, HttpServiceRuntime.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<HttpServiceRuntime, ServiceReference<HttpServiceRuntime>>(){

            public ServiceReference<HttpServiceRuntime> addingService(ServiceReference<HttpServiceRuntime> reference) {
                Object obj = reference.getProperty("service.changecount");
                if (obj != null) {
                    BaseTest.this.httpRuntimeChangeCount.set(Long.valueOf(obj.toString()));
                }
                return reference;
            }

            public void modifiedService(ServiceReference<HttpServiceRuntime> reference, ServiceReference<HttpServiceRuntime> service) {
                this.addingService(reference);
            }

            public void removedService(ServiceReference<HttpServiceRuntime> reference, ServiceReference<HttpServiceRuntime> service) {
                BaseTest.this.httpRuntimeChangeCount.set(-1L);
            }
        });
        this.runtimeTracker.open();
        this.runtimeTracker.waitForService(100L);
        this.startJetty();
    }

    @After
    public void tearDown() throws Exception {
        this.runtimeTracker.close();
        this.stopBundles();
        this.requestAdvisor = null;
        this.advisor = null;
        try {
            this.installer.shutdown();
        }
        finally {
            this.installer = null;
        }
        for (ServiceRegistration<? extends Object> serviceRegistration : this.registrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.registrations.clear();
    }

    protected String doRequest(String action, Map<String, String> params) throws IOException {
        return this.doRequestGetResponse(action, params).get("responseBody").get(0);
    }

    protected Map<String, List<String>> doRequestGetResponse(String action, Map<String, String> params) throws IOException {
        StringBuilder requestInfo = new StringBuilder(PROTOTYPE);
        requestInfo.append(action);
        if (!params.isEmpty()) {
            boolean firstParam = true;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (firstParam) {
                    requestInfo.append('?');
                    firstParam = false;
                } else {
                    requestInfo.append('&');
                }
                requestInfo.append(param.getKey());
                requestInfo.append('=');
                requestInfo.append(param.getValue());
            }
        }
        return this.requestAdvisor.request(requestInfo.toString(), null);
    }

    protected BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(BaseTest.class).getBundleContext();
    }

    protected String getContextPath() {
        return this.getJettyProperty("context.path", "");
    }

    protected HttpService getHttpService() {
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(HttpService.class);
        return (HttpService)this.getBundleContext().getService(serviceReference);
    }

    protected String getJettyProperty(String key, String defaultValue) {
        String qualifiedKey = JETTY_PROPERTY_PREFIX + key;
        String value = this.getProperty(qualifiedKey);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected void setJettyProperty(String key, String value) {
        String qualifiedKey = JETTY_PROPERTY_PREFIX + key;
        System.setProperty(qualifiedKey, value);
    }

    protected String getPort() {
        String defaultPort = this.getProperty(OSGI_HTTP_PORT_PROPERTY);
        if (defaultPort == null) {
            defaultPort = "80";
        }
        return this.getJettyProperty("port", defaultPort);
    }

    protected String getProperty(String key) {
        BundleContext bundleContext = this.getBundleContext();
        String value = bundleContext.getProperty(key);
        return value;
    }

    protected List<String> getStringPlus(String key, ServiceReference<?> ref) {
        Object property = ref.getProperty(key);
        if (String.class.isInstance(property)) {
            return Collections.singletonList((String)property);
        }
        if (String[].class.isInstance(property)) {
            return Arrays.asList((String[])property);
        }
        if (Collection.class.isInstance(property)) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object o : (Collection)property) {
                if (!(o instanceof String)) continue;
                list.add((String)o);
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected Bundle installBundle(String bundle) throws BundleException {
        return this.installer.installBundle(bundle);
    }

    protected void startBundles() throws BundleException {
    }

    protected void startJetty() throws Exception {
        this.advisor.startBundle(EQUINOX_JETTY_BUNDLE);
        ServiceReference runtimeReference = this.runtimeTracker.getServiceReference();
        List<String> endpoints = this.getStringPlus("osgi.http.endpoint", runtimeReference);
        String port = this.getPort();
        if (port.equals("0") && !endpoints.isEmpty()) {
            for (String endpoint : endpoints) {
                if (!endpoint.startsWith("http://")) continue;
                port = String.valueOf(new URL(endpoint).getPort());
                break;
            }
            if (port.equals("-1")) {
                port = "80";
            }
        }
        String contextPath = this.getContextPath();
        this.requestAdvisor = new ServletRequestAdvisor(port, contextPath);
    }

    protected void startJettyWithSSL(String port, String ksPath, String ksPassword, String keyPassword) throws Exception {
        if (port == null) {
            throw new IllegalArgumentException("Port cannot be null");
        }
        if (ksPath == null) {
            throw new IllegalArgumentException("Keystore path  cannot be null");
        }
        this.setJettyProperty("http.enabled", "false");
        this.setJettyProperty("https.enabled", "true");
        this.setJettyProperty("https.port", port);
        this.setJettyProperty("ssl.keystore", ksPath);
        if (ksPassword != null) {
            this.setJettyProperty("ssl.password", ksPassword);
        }
        if (keyPassword != null) {
            this.setJettyProperty("ssl.keypassword", keyPassword);
        }
        this.advisor.startBundle(EQUINOX_JETTY_BUNDLE);
        String contextPath = this.getContextPath();
        this.requestAdvisor = new ServletRequestAdvisor(port, contextPath, ksPath, ksPassword);
    }

    protected void stopBundles() throws BundleException {
    }

    protected void stopJetty() throws BundleException {
        this.advisor.stopBundle(EQUINOX_JETTY_BUNDLE);
    }

    protected void stopJettyWithSSL() throws BundleException {
        this.advisor.stopBundle(EQUINOX_JETTY_BUNDLE);
        this.setJettyProperty("http.enabled", "true");
        this.setJettyProperty("https.enabled", "false");
    }

    protected void uninstallBundle(Bundle bundle) throws BundleException {
        this.installer.uninstallBundle(bundle);
    }

    protected void write(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes(StandardCharsets.UTF_8));
    }

    protected FailedServletDTO getFailedServletDTOByName(String name) {
        FailedServletDTO[] failedServletDTOArray = this.getFailedServletDTOs();
        int n = failedServletDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailedServletDTO failedServletDTO = failedServletDTOArray[n2];
            if (name.equals(failedServletDTO.name)) {
                return failedServletDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedServletDTO[] getFailedServletDTOs() {
        HttpServiceRuntime httpServiceRuntime = this.getHttpServiceRuntime();
        return httpServiceRuntime.getRuntimeDTO().failedServletDTOs;
    }

    protected HttpServiceRuntime getHttpServiceRuntime() {
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(HttpServiceRuntime.class);
        Assert.assertNotNull((Object)serviceReference);
        return (HttpServiceRuntime)this.getBundleContext().getService(serviceReference);
    }

    protected ListenerDTO getListenerDTOByServiceId(String contextName, long serviceId) {
        ServletContextDTO servletContextDTO = this.getServletContextDTOByName(contextName);
        if (servletContextDTO == null) {
            return null;
        }
        ListenerDTO[] listenerDTOArray = servletContextDTO.listenerDTOs;
        int n = servletContextDTO.listenerDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerDTO listenerDTO = listenerDTOArray[n2];
            if (serviceId == listenerDTO.serviceId) {
                return listenerDTO;
            }
            ++n2;
        }
        return null;
    }

    protected long getServiceId(ServiceRegistration<?> sr) {
        return (Long)sr.getReference().getProperty("service.id");
    }

    protected RequestInfoDTO calculateRequestInfoDTO(String string) {
        HttpServiceRuntime httpServiceRuntime = this.getHttpServiceRuntime();
        return httpServiceRuntime.calculateRequestInfoDTO(string);
    }

    protected ServletDTO getServletDTOByName(String context, String name) {
        ServletContextDTO servletContextDTO = this.getServletContextDTOByName(context);
        if (servletContextDTO == null) {
            return null;
        }
        ServletDTO[] servletDTOArray = servletContextDTO.servletDTOs;
        int n = servletContextDTO.servletDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ServletDTO servletDTO = servletDTOArray[n2];
            if (name.equals(servletDTO.name)) {
                return servletDTO;
            }
            ++n2;
        }
        return null;
    }

    protected ServletContextDTO getServletContextDTOByName(String name) {
        ServletContextDTO[] servletContextDTOArray = this.getServletContextDTOs();
        int n = servletContextDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletContextDTO servletContextDTO = servletContextDTOArray[n2];
            if (name.equals(servletContextDTO.name)) {
                return servletContextDTO;
            }
            ++n2;
        }
        return null;
    }

    protected ServletContextDTO[] getServletContextDTOs() {
        return this.getHttpServiceRuntime().getRuntimeDTO().servletContextDTOs;
    }

    protected ErrorPageDTO getErrorPageDTOByName(String context, String name) {
        ServletContextDTO servletContextDTO = this.getServletContextDTOByName(context);
        if (servletContextDTO == null) {
            return null;
        }
        ErrorPageDTO[] errorPageDTOArray = servletContextDTO.errorPageDTOs;
        int n = servletContextDTO.errorPageDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorPageDTO errorPageDTO = errorPageDTOArray[n2];
            if (name.equals(errorPageDTO.name)) {
                return errorPageDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedErrorPageDTO getFailedErrorPageDTOByName(String name) {
        FailedErrorPageDTO[] failedErrorPageDTOArray = this.getFailedErrorPageDTOs();
        int n = failedErrorPageDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailedErrorPageDTO failedErrorPageDTO = failedErrorPageDTOArray[n2];
            if (name.equals(failedErrorPageDTO.name)) {
                return failedErrorPageDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedErrorPageDTO[] getFailedErrorPageDTOs() {
        HttpServiceRuntime httpServiceRuntime = this.getHttpServiceRuntime();
        return httpServiceRuntime.getRuntimeDTO().failedErrorPageDTOs;
    }

    protected FilterDTO getFilterDTOByName(String contextName, String name) {
        ServletContextDTO servletContextDTO = this.getServletContextDTOByName(contextName);
        if (servletContextDTO == null) {
            return null;
        }
        FilterDTO[] filterDTOArray = servletContextDTO.filterDTOs;
        int n = servletContextDTO.filterDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            FilterDTO filterDTO = filterDTOArray[n2];
            if (name.equals(filterDTO.name)) {
                return filterDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedFilterDTO getFailedFilterDTOByName(String name) {
        FailedFilterDTO[] failedFilterDTOArray = this.getFailedFilterDTOs();
        int n = failedFilterDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailedFilterDTO failedFilterDTO = failedFilterDTOArray[n2];
            if (name.equals(failedFilterDTO.name)) {
                return failedFilterDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedFilterDTO[] getFailedFilterDTOs() {
        return this.getHttpServiceRuntime().getRuntimeDTO().failedFilterDTOs;
    }

    protected FailedListenerDTO getFailedListenerDTOByServiceId(long serviceId) {
        FailedListenerDTO[] failedListenerDTOArray = this.getFailedListenerDTOs();
        int n = failedListenerDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailedListenerDTO failedListenerDTO = failedListenerDTOArray[n2];
            if (serviceId == failedListenerDTO.serviceId) {
                return failedListenerDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedListenerDTO[] getFailedListenerDTOs() {
        return this.getHttpServiceRuntime().getRuntimeDTO().failedListenerDTOs;
    }

    protected FailedServletContextDTO getFailedServletContextDTOByName(String name) {
        FailedServletContextDTO[] failedServletContextDTOArray = this.getFailedServletContextDTOs();
        int n = failedServletContextDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailedServletContextDTO failedServletContextDTO = failedServletContextDTOArray[n2];
            if (name.equals(failedServletContextDTO.name)) {
                return failedServletContextDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedServletContextDTO[] getFailedServletContextDTOs() {
        return this.getHttpServiceRuntime().getRuntimeDTO().failedServletContextDTOs;
    }

    protected ResourceDTO getResourceDTOByServiceId(String contextName, long serviceId) {
        ServletContextDTO servletContextDTO = this.getServletContextDTOByName(contextName);
        if (servletContextDTO == null) {
            return null;
        }
        ResourceDTO[] resourceDTOArray = servletContextDTO.resourceDTOs;
        int n = servletContextDTO.resourceDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceDTO resourceDTO = resourceDTOArray[n2];
            if (serviceId == resourceDTO.serviceId) {
                return resourceDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedResourceDTO getFailedResourceDTOByServiceId(long serviceId) {
        FailedResourceDTO[] failedResourceDTOArray = this.getFailedResourceDTOs();
        int n = failedResourceDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailedResourceDTO failedResourceDTO = failedResourceDTOArray[n2];
            if (serviceId == failedResourceDTO.serviceId) {
                return failedResourceDTO;
            }
            ++n2;
        }
        return null;
    }

    protected FailedResourceDTO[] getFailedResourceDTOs() {
        return this.getHttpServiceRuntime().getRuntimeDTO().failedResourceDTOs;
    }

    protected long waitForRegistration(long previousCount) {
        return this.waitForRegistration(previousCount, 100);
    }

    protected long waitForRegistration(long previousCount, int maxAttempts) {
        while (this.httpRuntimeChangeCount.longValue() == previousCount) {
            if (maxAttempts <= 0) {
                throw new IllegalStateException("Max attempts exceeded");
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            --maxAttempts;
        }
        return this.httpRuntimeChangeCount.longValue();
    }

    protected long getHttpRuntimeChangeCount() {
        return this.httpRuntimeChangeCount.longValue();
    }

    protected void registerDummyServletInHttpService() throws ServletException, NamespaceException {
        String path = "/tesths";
        HttpService service = this.getHttpService();
        service.registerServlet("/tesths", (Servlet)new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.getWriter().print("helloworld");
                resp.flushBuffer();
            }
        }, null, null);
    }

    protected void unregisterDummyServletFromHttpService() {
        this.getHttpService().unregister("/tesths");
    }

    protected ServletContextDTO getServletContextDTOForDummyServlet() {
        ServletContextDTO[] servletContextDTOArray = this.getHttpServiceRuntime().getRuntimeDTO().servletContextDTOs;
        int n = this.getHttpServiceRuntime().getRuntimeDTO().servletContextDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ServletContextDTO dto = servletContextDTOArray[n2];
            ServletDTO[] servletDTOArray = dto.servletDTOs;
            int n3 = dto.servletDTOs.length;
            int n4 = 0;
            while (n4 < n3) {
                ServletDTO sd = servletDTOArray[n4];
                if (sd.patterns.length > 0 && "/tesths".equals(sd.patterns[0])) {
                    return dto;
                }
                ++n4;
            }
            ++n2;
        }
        Assert.fail((String)"Servlet context for http service not found");
        return null;
    }

    protected FailedErrorPageDTO getFailedErrorPageDTOByException(String exception) {
        FailedErrorPageDTO[] failedErrorPageDTOArray = this.getFailedErrorPageDTOs();
        int n = failedErrorPageDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailedErrorPageDTO failedErrorPageDTO = failedErrorPageDTOArray[n2];
            String[] stringArray = failedErrorPageDTO.exceptions;
            int n3 = failedErrorPageDTO.exceptions.length;
            int n4 = 0;
            while (n4 < n3) {
                String ex = stringArray[n4];
                if (exception.equals(ex)) {
                    return failedErrorPageDTO;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    protected ErrorPageDTO getErrorPageDTOByException(String context, String exception) {
        ServletContextDTO servletContextDTO = this.getServletContextDTOByName(context);
        if (servletContextDTO == null) {
            return null;
        }
        ErrorPageDTO[] errorPageDTOArray = servletContextDTO.errorPageDTOs;
        int n = servletContextDTO.errorPageDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorPageDTO errorPageDTO = errorPageDTOArray[n2];
            String[] stringArray = errorPageDTO.exceptions;
            int n3 = errorPageDTO.exceptions.length;
            int n4 = 0;
            while (n4 < n3) {
                String ex = stringArray[n4];
                if (exception.equals(ex)) {
                    return errorPageDTO;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    protected static class ErrorServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private final String errorCode;

        public ErrorServlet(String errorCode) {
            this.errorCode = errorCode;
        }

        protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (response.isCommitted()) {
                System.out.println("Problem?");
                return;
            }
            PrintWriter writer = response.getWriter();
            String requestURI = (String)request.getAttribute("javax.servlet.error.request_uri");
            Integer status = (Integer)request.getAttribute("javax.servlet.error.status_code");
            writer.print(this.errorCode + " : " + String.valueOf(status) + " : ERROR : " + requestURI);
        }
    }

    protected class TestContextPathAdaptor
    extends ContextPathCustomizer {
        protected final String defaultFilter;
        protected final String contextPrefix;
        protected final String testName;

        public TestContextPathAdaptor(String defaultFilter, String contextPrefix, String testName) {
            this.defaultFilter = defaultFilter;
            this.contextPrefix = contextPrefix;
            this.testName = testName;
        }

        public String getDefaultContextSelectFilter(ServiceReference<?> httpWhiteBoardService) {
            if (this.testName.equals(httpWhiteBoardService.getProperty("servlet.init.test.path.customizer.name"))) {
                return this.defaultFilter;
            }
            return null;
        }

        public String getContextPathPrefix(ServiceReference<ServletContextHelper> helper) {
            if (this.testName.equals(helper.getProperty(BaseTest.TEST_PATH_CUSTOMIZER_NAME))) {
                return this.contextPrefix;
            }
            return null;
        }
    }

    protected static class TestFilter
    implements Filter {
        AtomicInteger called = new AtomicInteger(0);

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.called.incrementAndGet();
            chain.doFilter(request, response);
        }

        public void destroy() {
        }

        public void clear() {
            this.called.set(0);
        }

        public boolean getCalled() {
            return this.called.get() >= 1;
        }

        public int getCount() {
            return this.called.get();
        }
    }

    protected static class TestServletContextHelperFactory
    implements ServiceFactory<ServletContextHelper> {
        public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
            return new TestServletContextHelper(bundle);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
        }

        static class TestServletContextHelper
        extends ServletContextHelper {
            public TestServletContextHelper(Bundle bundle) {
                super(bundle);
            }
        }
    }
}

