/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.context.ServletContextHelper;

public class AuthenticationTest
extends BaseTest {
    private static final String AUTH_PAR = "auth";
    private static final String REC_PAR = "rec";

    @Test
    public void test_forwardSecurity() throws Exception {
        ArrayList<String> callStack = new ArrayList<String>();
        this.setup(callStack);
        this.requestAdvisor.request("context1/servlet?forward=true");
        Assert.assertTrue((boolean)callStack.isEmpty());
        this.requestAdvisor.request("context1/servlet?forward=true&auth=true");
        Assert.assertEquals((long)6L, (long)callStack.size());
        Assert.assertEquals(Arrays.asList("handle1", "servlet/context1", "handle1", "servlet/context1", "finish1", "finish1"), callStack);
        callStack.clear();
    }

    @Test
    public void test_handleFinishSecurity() throws Exception {
        ArrayList<String> callStack = new ArrayList<String>();
        this.setup(callStack);
        this.requestAdvisor.request("context1/servlet");
        Assert.assertTrue((boolean)callStack.isEmpty());
        this.requestAdvisor.request("context1/servlet?auth=true");
        Assert.assertEquals((long)3L, (long)callStack.size());
        Assert.assertEquals(Arrays.asList("handle1", "servlet/context1", "finish1"), callStack);
        callStack.clear();
        this.requestAdvisor.request("context2/servlet");
        Assert.assertEquals((long)3L, (long)callStack.size());
        Assert.assertEquals(Arrays.asList("handle2", "servlet/context2", "finish2"), callStack);
    }

    private void setup(final List<String> callStack) {
        BundleContext context = this.getBundleContext();
        Hashtable<String, String> ctx1Props = new Hashtable<String, String>();
        ((Dictionary)ctx1Props).put("osgi.http.whiteboard.context.name", "context1");
        ((Dictionary)ctx1Props).put("osgi.http.whiteboard.context.path", "/context1");
        this.registrations.add(context.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){

            public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
                if (request.getParameter(AuthenticationTest.AUTH_PAR) != null) {
                    callStack.add("handle1");
                    return true;
                }
                return false;
            }

            public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
                callStack.add("finish1");
            }
        }, ctx1Props));
        Hashtable<String, String> ctx2Props = new Hashtable<String, String>();
        ((Dictionary)ctx2Props).put("osgi.http.whiteboard.context.name", "context2");
        ((Dictionary)ctx2Props).put("osgi.http.whiteboard.context.path", "/context2");
        this.registrations.add(context.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){

            public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
                callStack.add("handle2");
                return true;
            }

            public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
                callStack.add("finish2");
            }
        }, ctx2Props));
        Hashtable<String, Object> servletProps = new Hashtable<String, Object>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", new String[]{"/servlet"});
        ((Dictionary)servletProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=context1)");
        class AServlet
        extends HttpServlet {
            private final /* synthetic */ List val$callStack;

            AServlet(List list) {
                this.val$callStack = list;
            }

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                this.val$callStack.add("servlet" + request.getContextPath());
                if (request.getContextPath().equals("/context1") && request.getAttribute(AuthenticationTest.REC_PAR) == null) {
                    if (request.getParameter("forward") != null) {
                        request.setAttribute(AuthenticationTest.REC_PAR, (Object)"true");
                        request.getRequestDispatcher("/servlet").forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    if (request.getParameter("include") != null) {
                        request.setAttribute(AuthenticationTest.REC_PAR, (Object)"true");
                        request.getRequestDispatcher("/servlet").include((ServletRequest)request, (ServletResponse)response);
                    } else if (request.getParameter("throw") != null) {
                        this.val$callStack.add("throw");
                        throw new ServletException("throw");
                    }
                }
                response.setStatus(200);
            }
        }
        this.registrations.add(context.registerService(Servlet.class, (Object)new AServlet(callStack), servletProps));
        ((Dictionary)servletProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=context2)");
        this.registrations.add(context.registerService(Servlet.class, (Object)new AServlet(callStack), servletProps));
    }
}

