/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.junit.Assert;
import org.junit.Test;

public class Bug562440_Test
extends BaseTest {
    @Test
    public void test_ServletGetStatus() throws Exception {
        final AtomicReference status = new AtomicReference();
        final AtomicReference<Boolean> error = new AtomicReference<Boolean>(false);
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                if (((Boolean)error.get()).booleanValue()) {
                    resp.sendError(404);
                }
                status.set(Integer.toString(resp.getStatus()));
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S1");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/S1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        this.requestAdvisor.request("S1/a");
        Assert.assertEquals((Object)"200", status.get());
        error.set(true);
        try {
            this.requestAdvisor.request("S1/a");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"404", status.get());
        }
    }

    @Test
    public void test_ServletFlushBuffer() throws Exception {
        final AtomicReference<Boolean> flushBuffer = new AtomicReference<Boolean>(false);
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.sendError(404, "NOT FOUND");
                if (((Boolean)flushBuffer.get()).booleanValue()) {
                    resp.flushBuffer();
                } else {
                    resp.getOutputStream().flush();
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S1");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/S1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        Map<String, List<String>> response = this.requestAdvisor.request("S1/a", null);
        Assert.assertEquals((Object)"404", (Object)response.get("responseCode").get(0));
        flushBuffer.set(true);
        response = this.requestAdvisor.request("S1/a", null);
        Assert.assertEquals((Object)"404", (Object)response.get("responseCode").get(0));
        Assert.assertTrue((boolean)response.get("responseBody").get(0).contains("NOT FOUND"));
    }
}

