/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.junit.Assert;
import org.junit.Test;

public class Bug562843_2_Test
extends BaseTest {
    @Test
    public void test_Bug562843_testEncodedSpace() throws Exception {
        final AtomicReference requestURI = new AtomicReference();
        final AtomicReference servletPath = new AtomicReference();
        final AtomicReference pathInfo = new AtomicReference();
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                requestURI.set(req.getRequestURI());
                servletPath.set(req.getServletPath());
                pathInfo.set(req.getPathInfo());
                PrintWriter writer = resp.getWriter();
                writer.write("OK");
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "Bug 562843");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Bug562843/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String path = "Bug562843/" + URLEncoder.encode("topic .html", "UTF-8");
        String result = this.requestAdvisor.request(path);
        Assert.assertEquals((Object)"OK", (Object)result);
        Assert.assertEquals((Object)"/Bug562843/topic+.html", requestURI.get());
        Assert.assertEquals((Object)"/Bug562843", servletPath.get());
        Assert.assertEquals((Object)"/topic .html", pathInfo.get());
    }

    @Test
    public void test_Bug562843_testEncodedPercentSign() throws Exception {
        final AtomicReference requestURI = new AtomicReference();
        final AtomicReference servletPath = new AtomicReference();
        final AtomicReference pathInfo = new AtomicReference();
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                requestURI.set(req.getRequestURI());
                servletPath.set(req.getServletPath());
                pathInfo.set(req.getPathInfo());
                PrintWriter writer = resp.getWriter();
                writer.write("OK");
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "Bug 562843");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Bug562843/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String path = "Bug562843/" + URLEncoder.encode("topic%.html", "UTF-8");
        String result = this.requestAdvisor.request(path);
        Assert.assertEquals((Object)"OK", (Object)result);
        Assert.assertEquals((Object)"/Bug562843/topic%25.html", requestURI.get());
        Assert.assertEquals((Object)"/Bug562843", servletPath.get());
        Assert.assertEquals((Object)"/topic%.html", pathInfo.get());
    }
}

