/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.junit.Assert;
import org.junit.Test;

public class Bug569406_Test
extends BaseTest {
    @Test
    public void test_Bug562843_Encode_Space() throws Exception {
        final AtomicReference requestURI = new AtomicReference();
        final AtomicReference servletPath = new AtomicReference();
        final AtomicReference pathInfo = new AtomicReference();
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                requestURI.set(req.getRequestURI());
                servletPath.set(req.getServletPath());
                pathInfo.set(req.getPathInfo());
                PrintWriter writer = resp.getWriter();
                writer.write("OK");
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "Bug 562843");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Bug 562843/this pat/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String result = this.requestAdvisor.request("Bug%20562843/this%20pat/a%20b%20c/d%20e%20f");
        Assert.assertEquals((Object)"OK", (Object)result);
        Assert.assertEquals((Object)"/Bug%20562843/this%20pat/a%20b%20c/d%20e%20f", requestURI.get());
        Assert.assertEquals((Object)"/Bug 562843/this pat", servletPath.get());
        Assert.assertEquals((Object)"/a b c/d e f", pathInfo.get());
    }

    @Test
    public void test_Bug562843_Encode_Slash() throws Exception {
        final AtomicReference requestURI = new AtomicReference();
        final AtomicReference servletPath = new AtomicReference();
        final AtomicReference pathInfo = new AtomicReference();
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                requestURI.set(req.getRequestURI());
                servletPath.set(req.getServletPath());
                pathInfo.set(req.getPathInfo());
                PrintWriter writer = resp.getWriter();
                writer.write("OK");
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "Bug 562843");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Bug 562843/this pat/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String result = this.requestAdvisor.request("Bug%20562843/this%20pat/aa%2Fb%2Fc/d%2Fe%2Ff");
        Assert.assertEquals((Object)"OK", (Object)result);
        Assert.assertEquals((Object)"/Bug%20562843/this%20pat/aa%2Fb%2Fc/d%2Fe%2Ff", requestURI.get());
        Assert.assertEquals((Object)"/Bug 562843/this pat", servletPath.get());
        Assert.assertEquals((Object)"/aa/b/c/d/e/f", pathInfo.get());
    }
}

