/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.eclipse.equinox.http.servlet.tests.util.BaseServlet;
import org.eclipse.equinox.http.servlet.tests.util.MockSCL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.context.ServletContextHelper;

public class ContextHelperCustomizerTests
extends BaseTest {
    @Rule
    public TestName testName = new TestName();
    private ServiceReference<HttpService> httpServiceReference;
    private HttpService httpService;
    private BundleContext context;

    @Before
    public void begin() {
        this.httpServiceReference = this.getBundleContext().getServiceReference(HttpService.class);
        this.context = this.httpServiceReference.getBundle().getBundleContext();
        this.httpService = (HttpService)this.context.getService(this.httpServiceReference);
    }

    @After
    public void end() {
        this.context.ungetService(this.httpServiceReference);
    }

    @Test
    public void testCreateDefaultHttpContextCreatesNewServletContextHelper() {
        HttpContext context1 = this.httpService.createDefaultHttpContext();
        HttpContext context2 = this.httpService.createDefaultHttpContext();
        Assert.assertNotEquals((Object)context1, (Object)context2);
    }

    @Test
    public void testServletContextHelpersNotHiddenWhenRegisteredUsingConsumingContext() {
        ServiceRegistration helperReg = null;
        ServiceRegistration findHookReg = null;
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.name", "context1");
            ((Dictionary)properties).put("osgi.http.whiteboard.context.path", "/context1");
            helperReg = this.context.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, properties);
            FindHook findHook = (bundleContext, name, filter, allServices, references) -> {
                if (bundleContext != this.context) {
                    return;
                }
                Iterator iterator = references.iterator();
                while (iterator.hasNext()) {
                    ServiceReference sr = (ServiceReference)iterator.next();
                    if (!"context1".equals(sr.getProperty("osgi.http.whiteboard.context.name"))) continue;
                    iterator.remove();
                }
            };
            findHookReg = this.context.registerService(FindHook.class, (Object)findHook, null);
            AtomicReference<ServletContext> sc1 = new AtomicReference<ServletContext>();
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.listener", "true");
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=context1)");
            this.context.registerService(ServletContextListener.class, (Object)new MockSCL(sc1), properties);
            Assert.assertNotNull((Object)sc1.get());
        }
        finally {
            if (helperReg != null) {
                helperReg.unregister();
            }
            if (findHookReg != null) {
                findHookReg.unregister();
            }
        }
    }

    @Test
    public void testWBServletContextPathCustomizerContextPrefix() throws Exception {
        ServiceRegistration pathAdaptorReg = null;
        ServiceRegistration helperReg = null;
        ServiceRegistration servlet = null;
        ServiceRegistration findHookReg = null;
        try {
            Hashtable<String, Object> helperProps = new Hashtable<String, Object>();
            ((Dictionary)helperProps).put("osgi.http.whiteboard.context.name", "testContext" + this.testName.getMethodName());
            ((Dictionary)helperProps).put("osgi.http.whiteboard.context.path", "/helperContext");
            ((Dictionary)helperProps).put("test.path.customizer.name", this.testName.getMethodName());
            helperReg = this.context.registerService(ServletContextHelper.class, (ServiceFactory)new BaseTest.TestServletContextHelperFactory(), helperProps);
            BaseTest.TestContextPathAdaptor pathAdaptor = new BaseTest.TestContextPathAdaptor(null, "testPrefix", this.testName.getMethodName());
            pathAdaptorReg = this.context.registerService(ContextPathCustomizer.class, (Object)pathAdaptor, null);
            FindHook findHook = (bundleContext, name, filter, allServices, references) -> {
                if (bundleContext != this.context) {
                    return;
                }
                Iterator iterator = references.iterator();
                while (iterator.hasNext()) {
                    ServiceReference sr = (ServiceReference)iterator.next();
                    if (!("testContext" + this.testName.getMethodName()).equals(sr.getProperty("osgi.http.whiteboard.context.name"))) continue;
                    iterator.remove();
                }
            };
            findHookReg = this.context.registerService(FindHook.class, (Object)findHook, null);
            BaseServlet baseServlet = new BaseServlet("content");
            Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
            ((Dictionary)serviceProps).put("osgi.http.whiteboard.servlet.pattern", "/servlet");
            ((Dictionary)serviceProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=testContext" + this.testName.getMethodName() + ")");
            servlet = this.context.registerService(Servlet.class, (Object)baseServlet, serviceProps);
            String actual = this.requestAdvisor.request("testPrefix/helperContext/servlet");
            Assert.assertEquals((Object)"content", (Object)actual);
        }
        finally {
            if (helperReg != null) {
                helperReg.unregister();
            }
            if (pathAdaptorReg != null) {
                pathAdaptorReg.unregister();
            }
            if (servlet != null) {
                servlet.unregister();
            }
            if (findHookReg != null) {
                findHookReg.unregister();
            }
        }
    }

    @Test
    public void testWBServletContextPathCustomizerDefaultFilter() throws Exception {
        ServiceRegistration pathAdaptorReg = null;
        ServiceRegistration helperReg = null;
        ServiceRegistration servlet = null;
        ServiceRegistration findHookReg = null;
        try {
            Hashtable<String, Object> helperProps = new Hashtable<String, Object>();
            ((Dictionary)helperProps).put("osgi.http.whiteboard.context.name", "testContext" + this.testName.getMethodName());
            ((Dictionary)helperProps).put("osgi.http.whiteboard.context.path", "/helperContext");
            ((Dictionary)helperProps).put("test.path.customizer.name", this.testName.getMethodName());
            helperReg = this.context.registerService(ServletContextHelper.class, (ServiceFactory)new BaseTest.TestServletContextHelperFactory(), helperProps);
            BaseTest.TestContextPathAdaptor pathAdaptor = new BaseTest.TestContextPathAdaptor("(osgi.http.whiteboard.context.name=testContext" + this.testName.getMethodName() + ")", null, this.testName.getMethodName());
            pathAdaptorReg = this.context.registerService(ContextPathCustomizer.class, (Object)pathAdaptor, null);
            FindHook findHook = (bundleContext, name, filter, allServices, references) -> {
                if (bundleContext != this.context) {
                    return;
                }
                Iterator iterator = references.iterator();
                while (iterator.hasNext()) {
                    ServiceReference sr = (ServiceReference)iterator.next();
                    if (!("testContext" + this.testName.getMethodName()).equals(sr.getProperty("osgi.http.whiteboard.context.name"))) continue;
                    iterator.remove();
                }
            };
            findHookReg = this.context.registerService(FindHook.class, (Object)findHook, null);
            BaseServlet baseServlet = new BaseServlet("content");
            Hashtable<String, String> serviceProps = new Hashtable<String, String>();
            ((Dictionary)serviceProps).put("osgi.http.whiteboard.servlet.pattern", "/servlet");
            ((Dictionary)serviceProps).put("servlet.init.test.path.customizer.name", this.testName.getMethodName());
            servlet = this.context.registerService(Servlet.class, (Object)baseServlet, serviceProps);
            String actual = this.requestAdvisor.request("helperContext/servlet");
            Assert.assertEquals((Object)"content", (Object)actual);
        }
        finally {
            if (helperReg != null) {
                helperReg.unregister();
            }
            if (pathAdaptorReg != null) {
                pathAdaptorReg.unregister();
            }
            if (servlet != null) {
                servlet.unregister();
            }
            if (findHookReg != null) {
                findHookReg.unregister();
            }
        }
    }

    @Test
    public void testLegacyServletContextPathCustomizerContextPrefix() throws Exception {
        ServiceRegistration pathAdaptorReg = null;
        ServiceRegistration findHookReg = null;
        try {
            BaseTest.TestContextPathAdaptor pathAdaptor = new BaseTest.TestContextPathAdaptor(this, null, "testPrefix", this.testName.getMethodName()){

                @Override
                public String getContextPathPrefix(ServiceReference<ServletContextHelper> helper) {
                    if (Boolean.TRUE.equals(helper.getProperty("equinox.legacy.context.helper"))) {
                        return this.contextPrefix;
                    }
                    return null;
                }
            };
            pathAdaptorReg = this.context.registerService(ContextPathCustomizer.class, (Object)pathAdaptor, null);
            FindHook findHook = (bundleContext, name, filter, allServices, references) -> {
                if (bundleContext != this.context) {
                    return;
                }
                Iterator iterator = references.iterator();
                while (iterator.hasNext()) {
                    ServiceReference sr = (ServiceReference)iterator.next();
                    if (Boolean.TRUE.equals(sr.getProperty("equinox.legacy.context.helper"))) {
                        iterator.remove();
                    }
                    iterator.remove();
                }
            };
            findHookReg = this.context.registerService(FindHook.class, (Object)findHook, null);
            BaseServlet baseServlet = new BaseServlet("content");
            this.httpService.registerServlet("/servlet", (Servlet)baseServlet, null, null);
            String actual = this.requestAdvisor.request("testPrefix/servlet");
            Assert.assertEquals((Object)"content", (Object)actual);
        }
        finally {
            if (pathAdaptorReg != null) {
                pathAdaptorReg.unregister();
            }
            if (findHookReg != null) {
                findHookReg.unregister();
            }
            this.httpService.unregister("/servlet");
        }
    }
}

