/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.eclipse.equinox.http.servlet.tests.util.BaseServlet;
import org.eclipse.equinox.http.servlet.tests.util.DispatchResultServlet;
import org.eclipse.equinox.http.servlet.tests.util.EventHandler;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.context.ServletContextHelper;

public class DispatchingTest
extends BaseTest {
    @Test
    @Ignore(value="https://github.com/eclipse/jetty.project/issues/10617")
    public void test_crossContextDispatch1() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
                StringWriter writer = new StringWriter();
                writer.write(request.getContextPath());
                writer.write("|");
                ServletContext servletContext = this.getServletContext().getContext("/");
                writer.write(servletContext.getContextPath());
                response.getWriter().write(writer.toString());
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        String response = this.requestAdvisor.request("a/s1/d");
        Assert.assertEquals((Object)"/a|", (Object)response);
    }

    @Test
    public void test_forwardDepth1() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"/a|/b|u=5|/a/s2/b|/s2|/a|/d|p=1|/a/s1/d|/s1", (Object)response);
    }

    @Test
    public void test_forwardDepth1_WithRequestFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                response.getWriter().write(98);
                super.doFilter(request, response, chain);
                response.getWriter().write(98);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"/a|/b|u=5|/a/s2/b|/s2|/a|/d|p=1|/a/s1/d|/s1", (Object)response);
        Assert.assertTrue((boolean)filter.getCalled());
    }

    @Test
    public void test_forwardDepth1_WithRequestAndForwardFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/i4?u=5").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                response.getWriter().write(98);
                super.doFilter(request, response, chain);
                response.getWriter().write(98);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.FORWARD.toString(), DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"b/a|/i4|u=5|/a/s2/i4|/s2|/a|/d|p=1|/a/s1/d|/s1b", (Object)response);
        Assert.assertEquals((long)2L, (long)filter.getCount());
    }

    @Test
    public void test_forwardDepth2() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/i2?p2=2").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet2 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s3/i3?p3=3").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet2, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s3/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("c1/s1/i1?p1=1");
        Assert.assertEquals((Object)"/c1|/i3|p3=3|/c1/s3/i3|/s3|/c1|/i1|p1=1|/c1/s1/i1|/s1", (Object)response);
    }

    @Test
    public void test_forwardDepth3() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/i2?p2=2").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet2 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s3/i3?p3=3").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet3 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s4/i4?p4=4").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet2, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s3/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet3, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s4/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("c1/s1/i1?p1=1");
        Assert.assertEquals((Object)"/c1|/i4|p4=4|/c1/s4/i4|/s4|/c1|/i1|p1=1|/c1/s1/i1|/s1", (Object)response);
    }

    @Test
    public void test_forwardNamedParameterAggregationAndPrecedence() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getNamedDispatcher("s2");
                requestDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            }
        };
        HttpServlet sB = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                PrintWriter writer = resp.getWriter();
                writer.write(String.valueOf(req.getQueryString()));
                writer.write("|");
                writer.write(String.valueOf(req.getAttribute("javax.servlet.include.query_string")));
                writer.write("|");
                writer.write(req.getParameter("p"));
                writer.write("|");
                writer.write(Arrays.toString(req.getParameterValues("p")));
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s2");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sB, props));
        String result = this.requestAdvisor.request("c1/s1/a?p=1&p=2");
        Assert.assertEquals((Object)"p=1&p=2|null|1|[1, 2]", (Object)result);
    }

    @Test
    public void test_forwardNamed() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getNamedDispatcher("s2");
                requestDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s2");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String result = this.requestAdvisor.request("c1/s1/a?p=1&p=2");
        Assert.assertEquals((Object)"/c1|/a|p=1&p=2|/c1/s1/a|/s1|null|null|null|null|null", (Object)result);
    }

    @Test
    public void test_forwardParameterAggregationAndPrecedence() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                RequestDispatcher requestDispatcher = req.getRequestDispatcher("/Servlet13B/a?p=3&p=4");
                requestDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            }
        };
        HttpServlet sB = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                PrintWriter writer = resp.getWriter();
                writer.write(req.getQueryString());
                writer.write("|");
                writer.write((String)req.getAttribute("javax.servlet.forward.query_string"));
                writer.write("|");
                writer.write(req.getParameter("p"));
                writer.write("|");
                writer.write(Arrays.toString(req.getParameterValues("p")));
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S13A");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet13A/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S13B");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet13B/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sB, props));
        String result = this.requestAdvisor.request("Servlet13A/a?p=1&p=2");
        Assert.assertEquals((Object)"p=3&p=4|p=1&p=2|3|[3, 4, 1, 2]", (Object)result);
    }

    @Test
    public void test_forwardStreamed() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"/a|/b|u=5|/a/s2/b|/s2|/a|/d|p=1|/a/s1/d|/s1", (Object)response);
    }

    @Test
    public void test_forwardStreamed_WithRequestFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
                super.doFilter(request, response, chain);
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"/a|/b|u=5|/a/s2/b|/s2|/a|/d|p=1|/a/s1/d|/s1", (Object)response);
        Assert.assertTrue((boolean)filter.getCalled());
    }

    @Test
    public void test_forwardStreamed_WithRequestAndForwardFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
                super.doFilter(request, response, chain);
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.FORWARD.toString(), DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"b/a|/b|u=5|/a/s2/b|/s2|/a|/d|p=1|/a/s1/d|/s1b", (Object)response);
        Assert.assertEquals((long)2L, (long)filter.getCount());
    }

    @Test
    public void test_includeBasic() throws Exception {
        HttpServlet servlet8 = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                RequestDispatcher requestDispatcher = request.getRequestDispatcher("/S8/target");
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        };
        HttpServlet servlet8Target = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.getWriter().print("s8target");
            }
        };
        HttpService httpService = this.getHttpService();
        HttpContext httpContext = httpService.createDefaultHttpContext();
        httpService.registerServlet("/S8", (Servlet)servlet8, null, httpContext);
        httpService.registerServlet("/S8/target", (Servlet)servlet8Target, null, httpContext);
        Assert.assertEquals((Object)"s8target", (Object)this.requestAdvisor.request("S8"));
    }

    @Test
    public void test_includeDepth1() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"/a|/d|p=1|/a/s1/d|/s1|/a|/b|u=5|/a/s2/b|/s2", (Object)response);
    }

    @Test
    public void test_includeDepth1_WithRequestFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                response.getWriter().write(98);
                super.doFilter(request, response, chain);
                response.getWriter().write(98);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"b/a|/d|p=1|/a/s1/d|/s1|/a|/b|u=5|/a/s2/b|/s2b", (Object)response);
        Assert.assertTrue((boolean)filter.getCalled());
    }

    @Test
    public void test_includeDepth1_WithRequestAndIncludeFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                response.getWriter().write(98);
                super.doFilter(request, response, chain);
                response.getWriter().write(98);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.INCLUDE.toString(), DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"bb/a|/d|p=1|/a/s1/d|/s1|/a|/b|u=5|/a/s2/b|/s2bb", (Object)response);
        Assert.assertEquals((long)2L, (long)filter.getCount());
    }

    @Test
    public void test_includeDepth2() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/i2?p2=2").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet2 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s3/i3?p3=3").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet2, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s3/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("c1/s1/i1?p1=1");
        Assert.assertEquals((Object)"/c1|/i1|p1=1|/c1/s1/i1|/s1|/c1|/i3|p3=3|/c1/s3/i3|/s3", (Object)response);
    }

    @Test
    public void test_includeDepth3() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/i2?p2=2").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet2 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s3/i3?p3=3").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet3 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s4/i4?p4=4").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet2, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s3/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet3, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s4/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("c1/s1/i1?p1=1");
        Assert.assertEquals((Object)"/c1|/i1|p1=1|/c1/s1/i1|/s1|/c1|/i4|p4=4|/c1/s4/i4|/s4", (Object)response);
    }

    @Test
    public void test_includeNamedParameterAggregationAndPrecedence() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getNamedDispatcher("s2");
                requestDispatcher.include((ServletRequest)req, (ServletResponse)resp);
            }
        };
        HttpServlet sB = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                PrintWriter writer = resp.getWriter();
                writer.write(req.getQueryString());
                writer.write("|");
                writer.write(String.valueOf(req.getAttribute("javax.servlet.include.query_string")));
                writer.write("|");
                writer.write(req.getParameter("p"));
                writer.write("|");
                writer.write(Arrays.toString(req.getParameterValues("p")));
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s2");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sB, props));
        String result = this.requestAdvisor.request("c1/s1/a?p=1&p=2");
        Assert.assertEquals((Object)"p=1&p=2|null|1|[1, 2]", (Object)result);
    }

    @Test
    public void test_includeNamed() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getNamedDispatcher("s2");
                requestDispatcher.include((ServletRequest)req, (ServletResponse)resp);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "c1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/c1");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s1");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "s2");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=c1)");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String result = this.requestAdvisor.request("c1/s1/a?p=1&p=2");
        Assert.assertEquals((Object)"/c1|/a|p=1&p=2|/c1/s1/a|/s1|null|null|null|null|null", (Object)result);
    }

    @Test
    public void test_includeParameterAggregationAndPrecedence() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                RequestDispatcher requestDispatcher = req.getRequestDispatcher("/Servlet13B/a?p=3&p=4");
                requestDispatcher.include((ServletRequest)req, (ServletResponse)resp);
            }
        };
        HttpServlet sB = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                PrintWriter writer = resp.getWriter();
                writer.write(req.getQueryString());
                writer.write("|");
                writer.write((String)req.getAttribute("javax.servlet.include.query_string"));
                writer.write("|");
                writer.write(req.getParameter("p"));
                writer.write("|");
                writer.write(Arrays.toString(req.getParameterValues("p")));
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S13A");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet13A/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S13B");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet13B/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sB, props));
        String result = this.requestAdvisor.request("Servlet13A/a?p=1&p=2");
        Assert.assertEquals((Object)"p=1&p=2|p=3&p=4|3|[3, 4, 1, 2]", (Object)result);
    }

    @Test
    public void test_includeStreamed() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"/a|/d|p=1|/a/s1/d|/s1|/a|/b|u=5|/a/s2/b|/s2", (Object)response);
    }

    @Test
    public void test_includeStreamed_WithRequestFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
                super.doFilter(request, response, chain);
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"b/a|/d|p=1|/a/s1/d|/s1|/a|/b|u=5|/a/s2/b|/s2b", (Object)response);
        Assert.assertTrue((boolean)filter.getCalled());
    }

    @Test
    public void test_includeStreamed_WithRequestAndIncludeFilter() throws Exception {
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("/s2/b?u=5").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
                super.doFilter(request, response, chain);
                DispatchingTest.this.write((OutputStream)response.getOutputStream(), "b");
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new DispatchResultServlet(), props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", new String[]{DispatcherType.INCLUDE.toString(), DispatcherType.REQUEST.toString()});
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("a/s1/d?p=1");
        Assert.assertEquals((Object)"bb/a|/d|p=1|/a/s1/d|/s1|/a|/b|u=5|/a/s2/b|/s2bb", (Object)response);
        Assert.assertEquals((long)2L, (long)filter.getCount());
    }

    @Test
    public void test_Bug479115() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(final HttpServletRequest req, HttpServletResponse resp) throws IOException {
                final AtomicReference results = new AtomicReference();
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        String[] parts = new String[]{req.getContextPath(), req.getRequestURI()};
                        results.set(parts);
                    }
                };
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie);
                }
                Assert.assertNotNull(results.get());
                PrintWriter writer = resp.getWriter();
                writer.write(((String[])results.get())[0]);
                writer.write("|");
                writer.write(((String[])results.get())[1]);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "Bug479115");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Bug479115/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String result = this.requestAdvisor.request("Bug479115/a");
        Assert.assertEquals((Object)"|/Bug479115/a", (Object)result);
    }

    @Test
    public void test_headers_include() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        final long date1 = System.currentTimeMillis() - 1187194880L;
        final long date2 = System.currentTimeMillis() - -1280385024L;
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.addCookie(new Cookie("foo", "bar"));
                response.addDateHeader("X-date", date1);
                response.addHeader("X-colour", "blue");
                response.addIntHeader("X-size", 20);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/plain");
                response.setHeader("X-animal", "cat");
                response.setLocale(Locale.CANADA);
                response.setBufferSize(1024);
                request.getRequestDispatcher("/s2").include((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet2 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) {
                response.addCookie(new Cookie("foo", "baz"));
                response.addDateHeader("X-date", date2);
                response.addHeader("X-colour", "green");
                response.addIntHeader("X-size", 30);
                response.setCharacterEncoding("UTF-16");
                response.setContentType("text/json");
                response.setHeader("X-animal", "bog");
                response.setLocale(Locale.US);
                response.setBufferSize(0);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet2, props));
        Map<String, List<String>> response = this.requestAdvisor.request("s1", null);
        Assert.assertNotNull(response.get("Set-Cookie"));
        Assert.assertEquals((Object)"foo=bar", (Object)response.get("Set-Cookie").get(0));
        Assert.assertNotNull(response.get("X-date"));
        Assert.assertEquals((Object)format.format(new Date(date1)), (Object)response.get("X-date").get(0));
        Assert.assertNotNull(response.get("X-colour"));
        Assert.assertEquals((Object)"blue", (Object)response.get("X-colour").get(0));
        Assert.assertNotNull(response.get("X-size"));
        Assert.assertEquals((Object)"20", (Object)response.get("X-size").get(0));
        String contentType = response.get("Content-Type").get(0);
        Assert.assertTrue((boolean)contentType.contains("text/plain;"));
        Assert.assertTrue((boolean)contentType.toLowerCase().contains("charset=utf-8"));
        Assert.assertEquals((Object)"en-CA", (Object)response.get("Content-Language").get(0));
        Assert.assertNotNull(response.get("X-animal"));
        Assert.assertEquals((Object)"cat", (Object)response.get("X-animal").get(0));
    }

    @Test
    public void test_headers_forward() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        final long date1 = System.currentTimeMillis() - 1187194880L;
        final long date2 = System.currentTimeMillis() - -1280385024L;
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.addCookie(new Cookie("foo", "bar"));
                response.addDateHeader("X-date", date1);
                response.addHeader("X-colour", "blue");
                response.addIntHeader("X-size", 20);
                response.setContentType("text/plain");
                response.setCharacterEncoding("UTF-8");
                response.setHeader("X-animal", "cat");
                response.setLocale(Locale.CANADA);
                response.setBufferSize(1024);
                request.getRequestDispatcher("/s2").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet2 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) {
                response.addCookie(new Cookie("foo", "baz"));
                response.addDateHeader("X-date", date2);
                response.addHeader("X-colour", "green");
                response.addIntHeader("X-size", 30);
                response.setContentType("text/json");
                response.setCharacterEncoding("UTF-16");
                response.setHeader("X-animal", "dog");
                response.setLocale(Locale.US);
                response.setBufferSize(0);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s2/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet2, props));
        Map<String, List<String>> response = this.requestAdvisor.request("s1", null);
        int multiValueIdx = new Version(18, 0, 0).compareTo(this.getJavaVersion()) > 0 ? 0 : 1;
        Assert.assertNotNull(response.get("Set-Cookie"));
        Assert.assertEquals((Object)"foo=baz", (Object)response.get("Set-Cookie").get(multiValueIdx));
        Assert.assertNotNull(response.get("X-date"));
        Assert.assertEquals((Object)format.format(new Date(date2)), (Object)response.get("X-date").get(multiValueIdx));
        Assert.assertNotNull(response.get("X-colour"));
        Assert.assertEquals((Object)"green", (Object)response.get("X-colour").get(multiValueIdx));
        Assert.assertNotNull(response.get("X-size"));
        Assert.assertEquals((Object)"30", (Object)response.get("X-size").get(multiValueIdx));
        String contentType = response.get("Content-Type").get(0);
        Assert.assertTrue((boolean)contentType.contains("text/json;"));
        Assert.assertTrue((boolean)contentType.toLowerCase().contains("charset=utf-16"));
        Assert.assertEquals((Object)"en-US", (Object)response.get("Content-Language").get(0));
        Assert.assertNotNull(response.get("X-animal"));
        Assert.assertEquals((Object)"dog", (Object)response.get("X-animal").get(0));
    }

    private Version getJavaVersion() {
        Bundle system = this.getBundleContext().getBundle("System Bundle");
        BundleWiring systemWiring = (BundleWiring)system.adapt(BundleWiring.class);
        List versions = systemWiring.getCapabilities("osgi.ee").stream().filter(c -> c.getAttributes().get("osgi.ee").equals("JavaSE")).findFirst().map(c -> (List)c.getAttributes().get("version")).get();
        return (Version)versions.get(versions.size() - 1);
    }

    @Test
    public void test_streamed_response_outputstream() throws Exception {
        long interval = 100L;
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.setContentType("text/event-stream");
                response.setCharacterEncoding("UTF-8");
                Throwable throwable = null;
                Object var4_5 = null;
                try (ServletOutputStream out = response.getOutputStream();){
                    int i = 1;
                    while (i <= 10) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            throw new ServletException((Throwable)e);
                        }
                        out.print("data: ");
                        out.print(System.currentTimeMillis());
                        out.print("\n\n");
                        out.flush();
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        final AtomicLong previousTime = new AtomicLong(System.currentTimeMillis());
        final AtomicInteger counter = new AtomicInteger();
        final AtomicBoolean result = new AtomicBoolean(true);
        EventHandler handler = new EventHandler(){

            @Override
            public void handle(Map<String, String> eventMap) {
                super.handle(eventMap);
                long currentTime = System.currentTimeMillis();
                long diff = currentTime - previousTime.get();
                System.out.println("Differential: " + diff);
                if (diff < 50L) {
                    result.set(false);
                }
                previousTime.set(currentTime);
                counter.incrementAndGet();
            }
        };
        this.requestAdvisor.eventSource("s1", null, handler);
        handler.close();
        Assert.assertTrue((String)"The interval between events was too short. It means that the response was not properly streamed.", (boolean)result.get());
        Assert.assertEquals((long)10L, (long)counter.get());
    }

    @Test
    public void test_streamed_response_writer() throws Exception {
        long interval = 100L;
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.setContentType("text/event-stream");
                response.setCharacterEncoding("UTF-8");
                Throwable throwable = null;
                Object var4_5 = null;
                try (PrintWriter writer = response.getWriter();){
                    int i = 1;
                    while (i <= 10) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            throw new ServletException((Throwable)e);
                        }
                        writer.print("data: ");
                        writer.print(System.currentTimeMillis());
                        writer.print("\n\n");
                        writer.flush();
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/s1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        final AtomicLong previousTime = new AtomicLong(System.currentTimeMillis());
        final AtomicInteger counter = new AtomicInteger();
        final AtomicBoolean result = new AtomicBoolean(true);
        EventHandler handler = new EventHandler(){

            @Override
            public void handle(Map<String, String> eventMap) {
                super.handle(eventMap);
                long currentTime = System.currentTimeMillis();
                long diff = currentTime - previousTime.get();
                System.out.println("Differential: " + diff);
                if (diff < 50L) {
                    result.set(false);
                }
                previousTime.set(currentTime);
                counter.incrementAndGet();
            }
        };
        this.requestAdvisor.eventSource("s1", null, handler);
        handler.close();
        Assert.assertTrue((String)"The interval between events was too short. It means that the response was not properly streamed.", (boolean)result.get());
        Assert.assertEquals((long)10L, (long)counter.get());
    }

    @Test
    public void test_Bug497510_1() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String requestURI = req.getRequestURI();
                Assert.assertNotNull((Object)requestURI);
                PrintWriter writer = resp.getWriter();
                writer.write(requestURI);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "Bug497510");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Bug497510/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String result = this.requestAdvisor.request("Bug497510/a%20b%20c");
        Assert.assertEquals((Object)"/Bug497510/a%20b%20c", (Object)result);
    }

    @Test
    public void test_Bug497510_2() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String requestURI = req.getRequestURI();
                Assert.assertNotNull((Object)requestURI);
                PrintWriter writer = resp.getWriter();
                writer.write(requestURI);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "Bug 497510");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Bug 497510/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String result = this.requestAdvisor.request("Bug%20497510/a%20b%20c");
        Assert.assertEquals((Object)"/Bug%20497510/a%20b%20c", (Object)result);
    }
}

