/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.eclipse.equinox.http.servlet.tests.util.MockPreprocessor;
import org.eclipse.equinox.http.servlet.tests.util.MockServlet;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.runtime.dto.PreprocessorDTO;
import org.osgi.service.http.whiteboard.Preprocessor;

public class PreprocessorTestCase
extends BaseTest {
    @Test
    public void testPreprocessorInitParameters() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("preprocessor.init.param1", "value1");
        ((Dictionary)properties).put("preprocessor.init.param2", "value2");
        ((Dictionary)properties).put("preprocessor.init.param3", 345L);
        long before = this.getHttpRuntimeChangeCount();
        ServiceRegistration reg = this.getBundleContext().registerService(Preprocessor.class, (Object)new MockPreprocessor(), properties);
        this.registrations.add(reg);
        this.waitForRegistration(before);
        PreprocessorDTO[] dtos = this.getHttpServiceRuntime().getRuntimeDTO().preprocessorDTOs;
        Assert.assertEquals((long)1L, (long)dtos.length);
        Assert.assertTrue((boolean)dtos[0].initParams.containsKey("param1"));
        Assert.assertTrue((boolean)dtos[0].initParams.containsKey("param2"));
        Assert.assertFalse((boolean)dtos[0].initParams.containsKey("param3"));
        Assert.assertEquals((long)this.getServiceId(reg), (long)dtos[0].serviceId);
    }

    @Test
    public void testPreprocessorRanking() throws Exception {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.ranking", -5);
        long before = this.getHttpRuntimeChangeCount();
        this.registrations.add(this.getBundleContext().registerService(Preprocessor.class.getName(), (Object)new MockPreprocessor().around("d"), properties));
        before = this.waitForRegistration(before);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.ranking", 8);
        this.registrations.add(this.getBundleContext().registerService(Preprocessor.class.getName(), (Object)new MockPreprocessor().around("a"), properties));
        before = this.waitForRegistration(before);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.ranking", 3L);
        this.registrations.add(this.getBundleContext().registerService(Preprocessor.class.getName(), (Object)new MockPreprocessor().around("b"), properties));
        before = this.waitForRegistration(before);
        properties = new Hashtable();
        this.registrations.add(this.getBundleContext().registerService(Preprocessor.class.getName(), (Object)new MockPreprocessor().around("c"), properties));
        before = this.waitForRegistration(before);
        PreprocessorDTO[] dtos = this.getHttpServiceRuntime().getRuntimeDTO().preprocessorDTOs;
        Assert.assertEquals((long)4L, (long)dtos.length);
        properties = new Hashtable();
        ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/available");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new MockServlet().content("hello"), properties));
        Assert.assertEquals((Object)"abcdhellodcba", (Object)this.requestAdvisor.request("available"));
    }

    @Test
    public void testPreprocessorInvocation() throws Exception {
        final ArrayList filterActions = new ArrayList();
        long before = this.getHttpRuntimeChangeCount();
        this.registrations.add(this.getBundleContext().registerService(Preprocessor.class.getName(), (Object)new MockPreprocessor(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                filterActions.add("a");
                super.doFilter(request, (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)response){
                    private boolean hasStatus;
                    {
                        super($anonymous0);
                        this.hasStatus = false;
                    }

                    private void addStatus(int sc) {
                        if (!this.hasStatus) {
                            this.hasStatus = true;
                            filterActions.add(String.valueOf(sc));
                        }
                    }

                    public void setStatus(int sc) {
                        this.addStatus(sc);
                        super.setStatus(sc);
                    }

                    public void sendError(int sc, String msg) throws IOException {
                        this.addStatus(sc);
                        super.sendError(sc, msg);
                    }

                    public void sendError(int sc) throws IOException {
                        this.addStatus(sc);
                        super.sendError(sc);
                    }
                }, chain);
                filterActions.add("b");
            }
        }, null));
        before = this.waitForRegistration(before);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/available");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new MockServlet().content("hello"), properties));
        Assert.assertEquals((Object)"hello", (Object)this.requestAdvisor.request("available"));
        Assert.assertEquals((long)2L, (long)filterActions.size());
        Assert.assertEquals((Object)"a", filterActions.get(0));
        Assert.assertEquals((Object)"b", filterActions.get(1));
        filterActions.clear();
        this.requestAdvisor.request("foo", null);
        Assert.assertEquals((long)3L, (long)filterActions.size());
        Assert.assertEquals((Object)"a", filterActions.get(0));
        Assert.assertEquals((Object)"404", filterActions.get(1));
        Assert.assertEquals((Object)"b", filterActions.get(2));
    }
}

