/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.eclipse.equinox.http.servlet.tests.util.MockServlet;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

public class TestHttpServiceAndNamedServlet
extends BaseTest {
    @Test
    public void testHttpServiceAndNamedServlet() throws Exception {
        this.registerDummyServletInHttpService();
        try {
            String name1 = "testname1";
            String name2 = "testname2";
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.name", "testname1");
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.httpservice=*)");
            long before = this.getHttpRuntimeChangeCount();
            this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new MockServlet(), properties));
            before = this.waitForRegistration(before);
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.name", "testname2");
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/testname2");
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.httpservice=*)");
            this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new MockServlet(), properties));
            before = this.waitForRegistration(before);
            Assert.assertNull((Object)this.getFailedServletDTOByName("testname1"));
            Assert.assertNotNull((String)String.valueOf(this.getHttpServiceRuntime().getRuntimeDTO()), (Object)this.getFailedServletDTOByName("testname2"));
            ServletContextDTO scDTO = this.getServletContextDTOForDummyServlet();
            Assert.assertNotNull((Object)this.getServletDTOByName(scDTO.name, "testname1"));
            Assert.assertNull((Object)this.getServletDTOByName(scDTO.name, "testname2"));
        }
        finally {
            this.unregisterDummyServletFromHttpService();
        }
    }
}

