/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.junit.Assert;
import org.junit.Test;

public class TestUpload
extends BaseTest {
    @Test
    public void testUpload() throws Exception {
        CountDownLatch receivedLatch = new CountDownLatch(1);
        HashMap<String, Long> contents = new HashMap<String, Long>();
        this.setupUploadServlet(receivedLatch, contents);
        this.postContent(this.getClass().getResource("resource1.txt"), 201);
        Assert.assertTrue((boolean)receivedLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals((long)26L, (long)((Long)contents.get("text.txt")));
    }

    private void setupUploadServlet(final CountDownLatch receivedLatch, final Map<String, Long> contents) {
        Hashtable<String, Object> servletProps = new Hashtable<String, Object>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/post");
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.multipart.enabled", Boolean.TRUE);
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.multipart.maxFileSize", 1024L);
        HttpServlet uploadServlet = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                try {
                    Collection parts = req.getParts();
                    for (Part p : parts) {
                        contents.put(p.getName(), p.getSize());
                    }
                    resp.setStatus(201);
                }
                finally {
                    receivedLatch.countDown();
                }
            }
        };
        long before = this.getHttpRuntimeChangeCount();
        this.registrations.add(this.getBundleContext().registerService(Servlet.class.getName(), (Object)uploadServlet, servletProps));
        this.waitForRegistration(before);
    }

    private void postContent(URL resource, int expectedRT) throws IOException {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("method", Arrays.asList("POST"));
        map.put("text.txt", Arrays.asList(resource));
        Map<String, List<String>> result = this.requestAdvisor.upload("post", map);
        Assert.assertEquals((Object)("" + expectedRT), (Object)result.get("responseCode").get(0));
    }
}

