/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.junit.Assert;
import org.junit.Test;

public class TestUploadWithParameter
extends BaseTest {
    @Test
    public void testUploadWithParameter() throws Exception {
        CountDownLatch receivedLatch = new CountDownLatch(1);
        HashMap<String, Object> contents = new HashMap<String, Object>();
        HashMap<String, String> contentsByKey = new HashMap<String, String>();
        this.setupUploadWithParameterServlet(receivedLatch, contents, contentsByKey);
        this.postContentWithParameter(this.getClass().getResource("resource1.txt"), 201);
        Assert.assertTrue((boolean)receivedLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)2L, (long)contents.size());
        Assert.assertEquals((Object)"Test", (Object)contents.get("single"));
        Assert.assertNotNull((Object)contents.get("multi"));
        Assert.assertTrue((boolean)(contents.get("multi") instanceof List));
        List multi = (List)contents.get("multi");
        Assert.assertEquals((long)3L, (long)multi.size());
        Assert.assertTrue((boolean)multi.contains("One"));
        Assert.assertTrue((boolean)multi.contains("Two"));
        Assert.assertTrue((boolean)multi.contains("Three"));
        Assert.assertEquals((long)2L, (long)contentsByKey.size());
        Assert.assertEquals((Object)"Test", (Object)contentsByKey.get("single"));
        Assert.assertEquals((Object)"One", (Object)contentsByKey.get("multi"));
    }

    private void setupUploadWithParameterServlet(final CountDownLatch receivedLatch, final Map<String, Object> contents, final Map<String, String> contentsByKey) {
        Hashtable<String, Object> servletProps = new Hashtable<String, Object>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/post");
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.multipart.enabled", Boolean.TRUE);
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.multipart.maxFileSize", 1024L);
        HttpServlet uploadServlet = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                try {
                    BufferedReader reader;
                    ArrayList collected = new ArrayList();
                    for (Part supportPart : req.getParts()) {
                        BufferedReader reader2;
                        Object var7_13;
                        Throwable throwable;
                        if (supportPart.getName().equals("multi")) {
                            throwable = null;
                            var7_13 = null;
                            try {
                                reader2 = new BufferedReader(new InputStreamReader(supportPart.getInputStream()));
                                try {
                                    List collect = reader2.lines().collect(Collectors.toList());
                                    if (collect == null || collect.isEmpty()) continue;
                                    collected.addAll(collect);
                                    continue;
                                }
                                finally {
                                    if (reader2 != null) {
                                        reader2.close();
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        if (!supportPart.getName().equals("single")) continue;
                        throwable = null;
                        var7_13 = null;
                        try {
                            reader2 = new BufferedReader(new InputStreamReader(supportPart.getInputStream()));
                            try {
                                contents.put("single", reader2.readLine());
                            }
                            finally {
                                if (reader2 != null) {
                                    reader2.close();
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    if (!collected.isEmpty()) {
                        contents.put("multi", collected);
                    }
                    Throwable throwable = null;
                    Iterator iterator = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(req.getPart("single").getInputStream()));
                        try {
                            contentsByKey.put("single", reader.readLine());
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    iterator = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(req.getPart("multi").getInputStream()));
                        try {
                            contentsByKey.put("multi", reader.readLine());
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                    resp.setStatus(201);
                }
                finally {
                    receivedLatch.countDown();
                }
            }
        };
        long before = this.getHttpRuntimeChangeCount();
        this.registrations.add(this.getBundleContext().registerService(Servlet.class.getName(), (Object)uploadServlet, servletProps));
        this.waitForRegistration(before);
    }

    private void postContentWithParameter(URL resource, int expectedRT) throws IOException {
        LinkedHashMap<String, List<Object>> header = new LinkedHashMap<String, List<Object>>();
        header.put("method", Arrays.asList("POST"));
        header.put("text.txt", Arrays.asList(resource));
        LinkedHashMap<String, Object> formFields = new LinkedHashMap<String, Object>();
        formFields.put("single", "Test");
        formFields.put("multi", Arrays.asList("One", "Two", "Three"));
        Map<String, List<String>> result = this.requestAdvisor.upload("post", header, formFields);
        Assert.assertEquals((Object)("" + expectedRT), (Object)result.get("responseCode").get(0));
    }
}

