/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.equinox.http.servlet.tests.util.EventHandler;
import org.junit.Assert;

public class ServletRequestAdvisor {
    private final String contextPath;
    private final String port;
    private final String ksPath;
    private final String ksPassword;
    private final int timeout;

    public ServletRequestAdvisor(String port, String contextPath) {
        this(port, contextPath, null, null, 150);
    }

    public ServletRequestAdvisor(String port, String contextPath, int timeout) {
        this(port, contextPath, null, null, timeout);
    }

    public ServletRequestAdvisor(String port, String contextPath, String ksPath, String ksPassword) {
        this(port, contextPath, ksPath, ksPassword, 150);
    }

    public ServletRequestAdvisor(String port, String contextPath, String ksPath, String ksPassword, int timeout) {
        if (port == null) {
            throw new IllegalArgumentException("port must not be null");
        }
        this.port = port;
        this.contextPath = contextPath;
        this.ksPath = ksPath;
        this.ksPassword = ksPassword;
        this.timeout = timeout * 100000;
    }

    private String createUrlSpec(String value, boolean isHttps) {
        StringBuilder buffer = new StringBuilder(100);
        String protocol = "http://";
        if (isHttps) {
            protocol = "https://";
        }
        String host = "localhost";
        buffer.append(protocol);
        buffer.append(host);
        buffer.append(':');
        buffer.append(this.port);
        buffer.append(this.contextPath);
        if (value != null) {
            buffer.append('/');
            buffer.append(value);
        }
        return buffer.toString();
    }

    private String createUrlSpec(String value) {
        return this.createUrlSpec(value, false);
    }

    private String drain(InputStream stream) throws IOException {
        int length;
        byte[] bytes = new byte[100];
        StringBuilder buffer = new StringBuilder(500);
        while ((length = stream.read(bytes)) != -1) {
            String chunk = new String(bytes, 0, length);
            buffer.append(chunk);
        }
        return buffer.toString();
    }

    private void log(String message) {
        String value = String.valueOf(this) + ": " + message;
        System.out.println(value);
    }

    public String request(String value) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.connect();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = connection.getInputStream();){
            return this.drain(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String requestHttps(String value) throws Exception {
        String spec = this.createUrlSpec(value, true);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        SSLContext sslContext = SSLContext.getInstance("SSL");
        this.initializeSSLContext(sslContext, this.ksPath, this.ksPassword);
        HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
        httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
        httpsConn.setRequestMethod("GET");
        httpsConn.setDoOutput(false);
        httpsConn.setDoInput(true);
        httpsConn.setConnectTimeout(this.timeout);
        httpsConn.setReadTimeout(this.timeout);
        httpsConn.connect();
        Assert.assertEquals((String)("Request to the url " + spec + " was not successful"), (long)200L, (long)httpsConn.getResponseCode());
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream stream = httpsConn.getInputStream();){
            return this.drain(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void initializeSSLContext(SSLContext sslContext, String ksPath, String ksPassword) throws Exception {
        KeyManager[] keyManagers = null;
        if (ksPath != null) {
            KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            File ksFile = new File(ksPath);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            Throwable throwable = null;
            Object var9_10 = null;
            try (FileInputStream ksStream = new FileInputStream(ksFile);){
                keyStore.load(ksStream, ksPassword.toCharArray());
                kmFactory.init(keyStore, ksPassword.toCharArray());
                keyManagers = kmFactory.getKeyManagers();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        TrustManager[] trustManagers = this.getTrustManager();
        sslContext.init(keyManagers, trustManagers, null);
    }

    private TrustManager[] getTrustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return trustAllCerts;
    }

    public Map<String, List<String>> request(String value, Map<String, List<String>> headers) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String entryValue : entry.getValue()) {
                    connection.setRequestProperty(entry.getKey(), entryValue);
                }
            }
        }
        int responseCode = connection.getResponseCode();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(connection.getHeaderFields());
        map.put("responseCode", Collections.singletonList(String.valueOf(responseCode)));
        try (InputStream stream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();){
            try {
                String drainedStream = this.drain(stream);
                map.put("responseBody", Arrays.asList(drainedStream));
            }
            catch (IOException e) {
                map.put("responseBody", Arrays.asList(e.getMessage()));
                stream.close();
            }
        }
        return map;
    }

    public Map<String, List<String>> eventSource(String value, Map<String, List<String>> headers, EventHandler handler) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setChunkedStreamingMode(0);
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String entryValue : entry.getValue()) {
                    connection.setRequestProperty(entry.getKey(), entryValue);
                }
            }
        }
        int responseCode = connection.getResponseCode();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(connection.getHeaderFields());
        map.put("responseCode", Collections.singletonList(String.valueOf(responseCode)));
        InputStream stream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();
        handler.open(stream);
        return map;
    }

    public Map<String, List<String>> upload(String value, Map<String, List<Object>> headers) throws IOException {
        return this.upload(value, headers, null);
    }

    public Map<String, List<String>> upload(String value, Map<String, List<Object>> headers, Map<String, Object> formFields) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setUseCaches(false);
        if (headers != null) {
            if (headers.containsKey("method")) {
                String method = (String)headers.remove("method").get(0);
                connection.setRequestMethod(method);
            }
            for (Map.Entry<String, List<Object>> entry : headers.entrySet()) {
                for (Object entryValue : entry.getValue()) {
                    if (entryValue instanceof String) {
                        if (entry.getKey().equals("x-www-form-urlencoded")) {
                            this.postFormURLEncoded(connection, (String)entryValue);
                            continue;
                        }
                        String property = connection.getRequestProperty(entry.getKey());
                        if (property == null) {
                            connection.setRequestProperty(entry.getKey(), (String)entryValue);
                            continue;
                        }
                        connection.setRequestProperty(entry.getKey(), property + "," + String.valueOf(entryValue));
                        continue;
                    }
                    if (entryValue instanceof URL) {
                        this.uploadFileConnection(connection, entry.getKey(), (URL)entryValue, formFields);
                        continue;
                    }
                    throw new IllegalArgumentException("only supports strings and files");
                }
            }
        }
        int responseCode = connection.getResponseCode();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(connection.getHeaderFields());
        map.put("responseCode", Collections.singletonList(String.valueOf(responseCode)));
        try (InputStream stream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();){
            map.put("responseBody", Arrays.asList(this.drain(stream)));
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
    }

    private void postFormURLEncoded(HttpURLConnection connection, String param) throws IOException {
        byte[] bytes = param.getBytes(StandardCharsets.UTF_8);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
            wr.write(bytes);
            wr.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadFileConnection(HttpURLConnection connection, String param, URL file, Map<String, Object> formFields) throws IOException {
        String fileName = file.getPath();
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        connection.setDoOutput(true);
        String boundary = Long.toHexString(System.currentTimeMillis());
        String CRLF = "\r\n";
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            InputStream input = file.openStream();
            try {
                block22: {
                    OutputStream output = connection.getOutputStream();
                    try {
                        try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), true);){
                            if (formFields != null) {
                                formFields.entrySet().forEach(entry -> {
                                    if (entry.getValue() instanceof Collection) {
                                        ((Collection)entry.getValue()).forEach(value -> {
                                            writer.append("--" + boundary);
                                            writer.append(CRLF);
                                            writer.append("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"");
                                            writer.append(CRLF);
                                            writer.append("Content-Type: text/plain; charset=UTF-8");
                                            writer.append(CRLF);
                                            writer.append(CRLF);
                                            writer.append((String)value);
                                            writer.append(CRLF);
                                            writer.flush();
                                        });
                                    } else {
                                        writer.append("--" + boundary);
                                        writer.append(CRLF);
                                        writer.append("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"");
                                        writer.append(CRLF);
                                        writer.append("Content-Type: text/plain; charset=UTF-8");
                                        writer.append(CRLF);
                                        writer.append(CRLF);
                                        writer.append((String)entry.getValue());
                                        writer.append(CRLF);
                                        writer.flush();
                                    }
                                });
                            }
                            writer.append("--" + boundary);
                            writer.append(CRLF);
                            writer.append("Content-Disposition: form-data; name=\"");
                            writer.append(param);
                            writer.append("\"; filename=\"");
                            writer.append(fileName);
                            writer.append("\"");
                            writer.append(CRLF);
                            writer.append("Content-Type: ");
                            String contentType = URLConnection.guessContentTypeFromName(fileName);
                            writer.append(contentType);
                            writer.append(CRLF);
                            if (!contentType.startsWith("text/")) {
                                writer.append("Content-Transfer-Encoding: binary");
                                writer.append(CRLF);
                            }
                            writer.append(CRLF);
                            writer.flush();
                            byte[] buf = new byte[64];
                            int c = 0;
                            while (true) {
                                if ((c = input.read(buf, 0, buf.length)) <= 0) {
                                    output.flush();
                                    writer.append(CRLF);
                                    writer.flush();
                                    writer.append("--" + boundary + "--");
                                    writer.append(CRLF);
                                    writer.flush();
                                    break;
                                }
                                output.write(buf, 0, c);
                                output.flush();
                            }
                        }
                        if (output == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (output == null) throw throwable;
                        output.close();
                        throw throwable;
                    }
                    output.close();
                }
                if (input == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            input.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

