/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.examples.readmetool.ReadmePlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.osgi.framework.Bundle;

public class AddReadmeMarkerAction
extends Action {
    private final ITextEditor textEditor;
    private final Object[][] customAttributes;
    private final String message;
    private static final String MARKER_TYPE = "org.eclipse.ui.examples.readmetool.readmemarker";

    public AddReadmeMarkerAction(ITextEditor editor, String label, Object[][] attributes, String message) {
        this.textEditor = editor;
        this.setText(label);
        this.customAttributes = attributes;
        this.message = message;
    }

    public void run() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(11);
        ITextSelection selection = (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            int start = selection.getOffset();
            int length = selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
            MarkerUtilities.setCharStart(attributes, (int)start);
            MarkerUtilities.setCharEnd(attributes, (int)(start + length));
            int line = selection.getStartLine();
            MarkerUtilities.setLineNumber(attributes, (int)(line == -1 ? -1 : line + 1));
            Object[][] objectArray = this.customAttributes;
            int n = this.customAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] customAttribute = objectArray[n2];
                attributes.put((String)customAttribute[0], customAttribute[1]);
                ++n2;
            }
            MarkerUtilities.setMessage(attributes, (String)this.message);
        }
        try {
            MarkerUtilities.createMarker((IResource)this.getResource(), attributes, (String)MARKER_TYPE);
        }
        catch (CoreException x) {
            Bundle bundle = ReadmePlugin.getDefault().getBundle();
            ILog.of((Bundle)bundle).log(x.getStatus());
            Shell shell = this.textEditor.getSite().getShell();
            String title = MessageUtil.getString("Add_readme_marker_error_title");
            String msg = MessageUtil.getString("Add_readme_marker_error_message");
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    protected IResource getResource() {
        IEditorInput input = this.textEditor.getEditorInput();
        return (IResource)Adapters.adapt((Object)input, IResource.class);
    }
}

