/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.ui.examples.readmetool.MarkElement;
import org.eclipse.ui.examples.readmetool.ReadmeContentOutlinePage;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class ReadmeContentOutlineDragListener
extends DragSourceAdapter {
    private final ReadmeContentOutlinePage page;

    public ReadmeContentOutlineDragListener(ReadmeContentOutlinePage page) {
        this.page = page;
    }

    public void dragSetData(DragSourceEvent event) {
        if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            byte[] segmentData = this.getSegmentText().getBytes();
            event.data = new PluginTransferData("org_eclipse_ui_examples_readmetool_drop_actions", segmentData);
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSegmentText();
            return;
        }
    }

    private String getSegmentText() {
        StringBuilder result = new StringBuilder();
        ISelection selection = this.page.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            result.append("\n");
            for (Object a : structuredSelection) {
                if (!(a instanceof MarkElement)) continue;
                MarkElement markElement = (MarkElement)a;
                result.append(markElement.getLabel(a));
                result.append("\n");
            }
        }
        return result.toString();
    }
}

