/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.ide.IDE;

public class ReadmeCreationPage
extends WizardNewFileCreationPage {
    private final IWorkbench workbench;
    private Button sectionCheckbox;
    private Button subsectionCheckbox;
    private Button openFileCheckbox;
    private static int nameCounter = 1;

    public ReadmeCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("sampleCreateReadmePage1", selection);
        this.setTitle(MessageUtil.getString("Create_Readme_File"));
        this.setDescription(MessageUtil.getString("Create_a_new_Readme_file_resource"));
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.examples.readmetool.creation_wizard_page_context");
        this.setFileName("sample" + nameCounter + ".readme");
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(MessageUtil.getString("Automatic_sample_section_generation"));
        group.setLayoutData((Object)new GridData(768));
        this.sectionCheckbox = new Button((Composite)group, 32);
        this.sectionCheckbox.setText(MessageUtil.getString("Generate_sample_section_titles"));
        this.sectionCheckbox.setSelection(true);
        this.sectionCheckbox.addListener(13, (Listener)this);
        this.subsectionCheckbox = new Button((Composite)group, 32);
        this.subsectionCheckbox.setText(MessageUtil.getString("Generate_sample_subsection_titles"));
        this.subsectionCheckbox.setSelection(true);
        this.subsectionCheckbox.addListener(13, (Listener)this);
        this.openFileCheckbox = new Button(composite, 32);
        this.openFileCheckbox.setText(MessageUtil.getString("Open_file_for_editing_when_done"));
        this.openFileCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow;
            IWorkbenchPage page;
            if (this.openFileCheckbox.getSelection() && (page = (dwindow = this.workbench.getActiveWorkbenchWindow()).getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        ++nameCounter;
        return true;
    }

    protected InputStream getInitialContents() {
        if (!this.sectionCheckbox.getSelection()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MessageUtil.getString("SAMPLE_README_FILE"));
        sb.append(MessageUtil.getString("SECTION_1"));
        sb.append(MessageUtil.getString("SECTION_1_BODY_1"));
        if (this.subsectionCheckbox.getSelection()) {
            sb.append(MessageUtil.getString("Subsection_1_1"));
            sb.append(MessageUtil.getString("Subsection_1_1_Body_1"));
        }
        sb.append(MessageUtil.getString("SECTION_2"));
        sb.append(MessageUtil.getString("SECTION_2_BODY_1"));
        sb.append(MessageUtil.getString("SECTION_2_BODY_2"));
        if (this.subsectionCheckbox.getSelection()) {
            sb.append(MessageUtil.getString("Subsection_2_1"));
            sb.append(MessageUtil.getString("Subsection_2_1_BODY_1"));
            sb.append(MessageUtil.getString("Subsection_2_2"));
            sb.append(MessageUtil.getString("Subsection_2_2_BODY_1"));
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    protected String getNewFileLabel() {
        return MessageUtil.getString("Readme_file_name");
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.sectionCheckbox) {
            if (!this.sectionCheckbox.getSelection()) {
                this.subsectionCheckbox.setSelection(false);
            }
            this.subsectionCheckbox.setEnabled(this.sectionCheckbox.getSelection());
        }
        super.handleEvent(e);
    }
}

