/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.Policy;
import org.eclipse.team.examples.filesystem.StreamUtil;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;

public class FileSystemOperations {
    private final FileSystemProvider provider;

    FileSystemOperations(FileSystemProvider provider) {
        this.provider = provider;
    }

    public void get(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("GetAction.working"), 100);
            FileSystemSubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progress, (int)30));
            this.internalGet(resources, depth, overrideOutgoing, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progress, (int)70));
        }
        finally {
            progress.done();
        }
    }

    public void get(ResourceTraversal[] traversals, boolean overrideOutgoing, IProgressMonitor monitor) throws TeamException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            ResourceTraversal[] resourceTraversalArray = traversals;
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceTraversal traversal = resourceTraversalArray[n2];
                this.get(traversal.getResources(), traversal.getDepth(), overrideOutgoing, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void checkout(IResource[] resources, int depth, IProgressMonitor progress) throws TeamException {
        try {
            try {
                progress = Policy.monitorFor(progress);
                progress.beginTask(Policy.bind("FileSystemSimpleAccessOperations.1"), resources.length);
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource2 = iResourceArray[n2];
                    Policy.checkCanceled(progress);
                    resource2.accept(resource -> {
                        if (resource.getType() == 1) {
                            resource.setReadOnly(false);
                        }
                        return true;
                    }, depth, false);
                    progress.worked(1);
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        finally {
            progress.done();
        }
    }

    public void checkin(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("PutAction.working"), 100);
            FileSystemSubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progress, (int)30));
            this.internalPut(resources, depth, overrideIncoming, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progress, (int)70));
        }
        finally {
            progress.done();
        }
    }

    public void checkin(ResourceTraversal[] traversals, boolean overrideIncoming, IProgressMonitor monitor) throws TeamException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            ResourceTraversal[] resourceTraversalArray = traversals;
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceTraversal traversal = resourceTraversalArray[n2];
                this.checkin(traversal.getResources(), traversal.getDepth(), overrideIncoming, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isCheckedOut(IResource resource) {
        if (resource.getType() != 1) {
            return true;
        }
        return !resource.isReadOnly();
    }

    private FileSystemResourceVariant getResourceVariant(IResource resource) {
        return (FileSystemResourceVariant)this.provider.getResourceVariant(resource);
    }

    private void internalGet(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        progress.beginTask(Policy.bind("GetAction.working"), -1);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Policy.checkCanceled(progress);
            if (resource.getType() == 1) {
                this.internalGet((IFile)resource, overrideOutgoing, progress);
            } else if (depth != 0) {
                this.internalGet((IContainer)resource, depth, overrideOutgoing, progress);
            }
            progress.worked(1);
            ++n2;
        }
    }

    private void internalGet(IContainer container, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        try {
            IResource[] children;
            ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
            ArrayList<IFolder> toDelete = new ArrayList<IFolder>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                FileSystemResourceVariant remote = this.getResourceVariant((IResource)container);
                if (!folder.exists() && remote != null) {
                    folder.create(false, true, progress);
                    synchronizer.setBaseBytes((IResource)folder, remote.asBytes());
                } else if (folder.exists() && remote == null) {
                    toDelete.add(folder);
                }
            }
            if ((children = synchronizer.members((IResource)container)).length > 0) {
                this.internalGet(children, depth == 2 ? 2 : 0, overrideOutgoing, progress);
            }
            for (IFolder folder : toDelete) {
                if (folder.members().length != 0) continue;
                folder.delete(false, true, progress);
                synchronizer.flush((IResource)folder, 2);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    private void internalGet(IFile localFile, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = FileSystemSubscriber.getInstance().getResourceComparator();
        FileSystemResourceVariant remote = this.getResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        IResourceVariant base = this.provider.getResourceVariant((IResource)localFile, baseBytes);
        if (!synchronizer.hasSyncBytes((IResource)localFile) || this.isLocallyModified(localFile) && !overrideOutgoing) {
            return;
        }
        if (base != null && remote == null) {
            try {
                localFile.delete(false, true, progress);
                synchronizer.flush((IResource)localFile, 0);
                return;
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        if (!synchronizer.isLocallyModified((IResource)localFile) && base != null && remote != null && comparator.compare(base, (IResourceVariant)remote)) {
            return;
        }
        try {
            Throwable e = null;
            Object var10_14 = null;
            try (InputStream source = remote.getContents();){
                if (localFile.exists()) {
                    localFile.setContents(source, false, false, progress);
                } else {
                    localFile.create(source, false, progress);
                }
                localFile.setReadOnly(true);
                synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw FileSystemPlugin.wrapException(e);
        }
        catch (CoreException e) {
            throw FileSystemPlugin.wrapException(e);
        }
    }

    private void internalPut(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        progress = Policy.monitorFor(progress);
        progress.beginTask(Policy.bind("PutAction.working"), -1);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Policy.checkCanceled(progress);
            if (resource.getType() == 1) {
                this.internalPut((IFile)resource, overrideIncoming, progress);
            } else if (depth > 0) {
                this.internalPut((IContainer)resource, depth, overrideIncoming, progress);
            }
            progress.worked(1);
            ++n2;
        }
        progress.done();
    }

    private boolean internalPut(IFile localFile, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = FileSystemSubscriber.getInstance().getResourceComparator();
        FileSystemResourceVariant remote = this.getResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        IResourceVariant base = this.provider.getResourceVariant((IResource)localFile, baseBytes);
        if (base == null && remote != null && !overrideIncoming) {
            return false;
        }
        if (base != null && remote == null) {
            if (!localFile.exists()) {
                synchronizer.flush((IResource)localFile, 0);
            } else if (!overrideIncoming) {
                return false;
            }
        } else if (base != null && remote != null) {
            boolean same = comparator.compare(base, (IResourceVariant)remote);
            if (!this.isLocallyModified(localFile) && same) {
                return true;
            }
            if (!same && !overrideIncoming) {
                return false;
            }
        }
        File diskFile = this.provider.getFile((IResource)localFile);
        if (!localFile.exists()) {
            diskFile.delete();
            synchronizer.flush((IResource)localFile, 0);
        } else {
            try {
                Throwable throwable = null;
                Object var11_15 = null;
                try (InputStream in = localFile.getContents();){
                    if (!diskFile.getParentFile().exists()) {
                        diskFile.getParentFile().mkdirs();
                    }
                    Throwable throwable2 = null;
                    Object var14_20 = null;
                    try (FileOutputStream out = new FileOutputStream(diskFile);){
                        StreamUtil.pipe(in, out, diskFile.length(), progress, diskFile.getName());
                        localFile.setReadOnly(true);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    remote = this.getResourceVariant((IResource)localFile);
                    synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw FileSystemPlugin.wrapException(e);
            }
            catch (CoreException e) {
                throw FileSystemPlugin.wrapException(e);
            }
        }
        return true;
    }

    private boolean isLocallyModified(IFile localFile) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        if (!localFile.exists()) {
            return synchronizer.getBaseBytes((IResource)localFile) != null;
        }
        return synchronizer.isLocallyModified((IResource)localFile);
    }

    private void internalPut(IContainer container, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        try {
            IResource[] children;
            ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
            ArrayList<File> toDelete = new ArrayList<File>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                File diskFile = this.provider.getFile((IResource)container);
                FileSystemResourceVariant remote = this.getResourceVariant((IResource)container);
                if (!folder.exists() && remote != null) {
                    toDelete.add(diskFile);
                } else if (folder.exists() && remote == null) {
                    diskFile.mkdir();
                    synchronizer.setBaseBytes((IResource)folder, this.provider.getResourceVariant((IResource)folder).asBytes());
                }
            }
            if ((children = synchronizer.members((IResource)container)).length > 0) {
                this.internalPut(children, depth == 2 ? 2 : 0, overrideIncoming, progress);
            }
            for (File diskFile : toDelete) {
                File[] fileList = diskFile.listFiles();
                if (fileList == null) {
                    throw new TeamException("Content from directory '" + diskFile.getAbsolutePath() + "' can not be listed.");
                }
                if (fileList.length != 0) continue;
                diskFile.delete();
                synchronizer.flush((IResource)container, 2);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }
}

