/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class FileSystemFileRevision
extends FileRevision {
    File remoteFile;

    public FileSystemFileRevision(File file) {
        this.remoteFile = file;
    }

    public String getName() {
        return this.remoteFile.getName();
    }

    public long getTimestamp() {
        return this.remoteFile.lastModified();
    }

    public IStorage getStorage(IProgressMonitor monitor) {
        return new IStorage(){

            public InputStream getContents() {
                try {
                    return Files.newInputStream(FileSystemFileRevision.this.remoteFile.toPath(), new OpenOption[0]);
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            public IPath getFullPath() {
                return IPath.fromOSString((String)FileSystemFileRevision.this.remoteFile.getAbsolutePath());
            }

            public String getName() {
                return FileSystemFileRevision.this.remoteFile.getName();
            }

            public boolean isReadOnly() {
                return true;
            }

            public <T> T getAdapter(Class<T> adapter) {
                return null;
            }
        };
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) {
        return null;
    }

    public String getContentIdentifier() {
        return "[File System Revision]";
    }
}

