/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.history;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.history.FileSystemFileRevision;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.team.internal.core.history.LocalFileRevision;

public class FileSystemHistory
extends FileHistory {
    private final IFile file;
    protected IFileRevision[] revisions;

    public FileSystemHistory(IFile file) {
        this.file = file;
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        return null;
    }

    public IFileRevision getFileRevision(String id) {
        return null;
    }

    public IFileRevision[] getFileRevisions() {
        return this.revisions;
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        return null;
    }

    public void refresh(IProgressMonitor monitor) {
        try {
            FileSystemProvider fileProvider;
            IResourceVariant resVar;
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.file.getProject());
            if (provider != null && provider instanceof FileSystemProvider && (resVar = (fileProvider = (FileSystemProvider)provider).getResourceVariant((IResource)this.file)) instanceof FileSystemResourceVariant) {
                FileSystemResourceVariant resVarF = (FileSystemResourceVariant)resVar;
                File javaFile = resVarF.getFile();
                IFileState[] states = this.file.getHistory(monitor);
                this.revisions = new IFileRevision[states.length + 1];
                int i = 0;
                while (i < states.length) {
                    this.revisions[i] = new LocalFileRevision(states[i]);
                    ++i;
                }
                this.revisions[i] = new FileSystemFileRevision(javaFile);
            }
        }
        catch (TeamException teamException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

