/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.subscriber;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ThreeWayRemoteTree;
import org.eclipse.team.core.variants.ThreeWaySubscriber;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemRemoteTree;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSyncInfo;

public class FileSystemSubscriber
extends ThreeWaySubscriber {
    private static FileSystemSubscriber instance;

    public static synchronized FileSystemSubscriber getInstance() {
        if (instance == null) {
            instance = new FileSystemSubscriber();
        }
        return instance;
    }

    private FileSystemSubscriber() {
        super(new ThreeWaySynchronizer(new QualifiedName("org.eclipse.team.examples.filesystem", "workpsace-sync")));
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
        if (provider != null) {
            return ((FileSystemProvider)provider).getResourceVariant(resource, bytes);
        }
        return null;
    }

    protected ThreeWayRemoteTree createRemoteTree() {
        return new FileSystemRemoteTree(this);
    }

    public String getName() {
        return "File System Example";
    }

    public IResource[] roots() {
        IProject[] projects;
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryProvider provider;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider")) != null) {
                result.add(project);
            }
            ++n2;
        }
        return (IResource[])result.toArray(new IProject[result.size()]);
    }

    public void handleRootChanged(IResource resource, boolean added) {
        super.handleRootChanged(resource, added);
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        FileSystemSyncInfo info = new FileSystemSyncInfo(local, base, remote, this.getResourceComparator());
        info.init();
        return info;
    }

    public void makeInSync(IResource resource) throws TeamException {
        ThreeWaySynchronizer synchronizer = this.getSynchronizer();
        byte[] remoteBytes = synchronizer.getRemoteBytes(resource);
        if (remoteBytes == null) {
            if (!resource.exists()) {
                synchronizer.flush(resource, 0);
            }
        } else {
            synchronizer.setBaseBytes(resource, remoteBytes);
        }
    }

    public void markAsMerged(IResource resource, IProgressMonitor monitor) throws TeamException {
        this.makeInSync(resource);
        try {
            resource.touch(monitor);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }
}

