/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileSystemRevisionEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput {
    private final IFileRevision fileRevision;
    private IStorage storage;

    public FileSystemRevisionEditorInput(IFileRevision revision) {
        this.fileRevision = revision;
        try {
            this.storage = revision.getStorage((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (this.storage != null) {
            return this.storage.getName();
        }
        return "";
    }

    public Object getParent(Object o) {
        return null;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.fileRevision != null) {
            return this.fileRevision.getName() + " " + this.fileRevision.getContentIdentifier();
        }
        if (this.storage != null) {
            return this.storage.getName() + " " + DateFormat.getInstance().format(new Date(((IFileState)this.storage).getModificationTime()));
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.fileRevision != null) {
            return this.getStorage().getFullPath().toString();
        }
        if (this.storage != null) {
            return this.storage.getFullPath().toString();
        }
        return "";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast((Object)this);
        }
        if (adapter == IFileRevision.class) {
            return adapter.cast(this.fileRevision);
        }
        if (adapter == IFileState.class && this.storage != null && this.storage instanceof IFileState) {
            return adapter.cast(this.storage);
        }
        return (T)super.getAdapter(adapter);
    }
}

