/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.Policy;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.team.examples.filesystem.ui.FileSystemOperation;
import org.eclipse.ui.IWorkbenchPart;

public class GetOperation
extends FileSystemOperation {
    private boolean overwriteOutgoing;

    public GetOperation(IWorkbenchPart part, SubscriberScopeManager manager) {
        super(part, manager);
    }

    @Override
    protected void execute(FileSystemProvider provider, ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        provider.getOperations().get(traversals, this.isOverwriteOutgoing(), monitor);
        if (!this.isOverwriteOutgoing() && this.hasIncomingChanges(traversals)) {
            throw new TeamException("Could not get all changes due to conflicts.");
        }
    }

    private boolean hasIncomingChanges(ResourceTraversal[] traversals) throws CoreException {
        RuntimeException found = new RuntimeException();
        try {
            FileSystemSubscriber.getInstance().accept(traversals, diff -> {
                IThreeWayDiff twd;
                if (diff instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)diff).getDirection() == 512 || twd.getDirection() == 768)) {
                    throw found;
                }
                return false;
            });
        }
        catch (RuntimeException e) {
            if (e == found) {
                return true;
            }
            throw e;
        }
        return false;
    }

    protected boolean isOverwriteOutgoing() {
        return this.overwriteOutgoing;
    }

    public void setOverwriteOutgoing(boolean overwriteOutgoing) {
        this.overwriteOutgoing = overwriteOutgoing;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("GetAction.working");
    }
}

