/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.examples.filesystem.ui.NonSyncMergePart;
import org.eclipse.team.examples.filesystem.ui.NonSyncModelMergeOperation;
import org.eclipse.team.examples.filesystem.ui.NonSyncModelMergePage;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.team.ui.SaveablePartDialog;

public class NonSyncMergeDialog
extends SaveablePartDialog {
    public static void openFor(NonSyncModelMergeOperation operation) {
        NonSyncModelMergePage page = new NonSyncModelMergePage((IMergeContext)operation.getContext());
        NonSyncMergePart part = new NonSyncMergePart(operation.getShell(), new CompareConfiguration(), page);
        NonSyncMergeDialog dialog = new NonSyncMergeDialog(operation.getShell(), (ISaveableWorkbenchPart)part);
        dialog.open();
    }

    public NonSyncMergeDialog(Shell shell, ISaveableWorkbenchPart input) {
        super(shell, input);
    }

    protected void buttonPressed(int buttonId) {
        NonSyncMergePart part;
        IMergeContext context;
        if (buttonId == 0 && this.hasUnmergedChanges(context = (part = (NonSyncMergePart)this.getInput()).getContext()) && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"Unmerged Changes", (String)"There are still unmerged changes. Are you sure you want to close the dialog?")) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    private boolean hasUnmergedChanges(IMergeContext context) {
        return context.getDiffTree().hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                if (diff instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)diff;
                    return twd.getDirection() == 512 || twd.getDirection() == 768;
                }
                return false;
            }
        });
    }
}

