/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.examples.filesystem.ui.FileSystemRevisionEditorInput;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IProgressService;

public class OpenFileSystemRevisionAction
extends BaseSelectionListenerAction {
    private IStructuredSelection selection;
    HistoryPage page;

    public OpenFileSystemRevisionAction(String text) {
        super(text);
    }

    public void run() {
        Object[] objArray;
        IStructuredSelection structSel = this.selection;
        Object[] objectArray = objArray = structSel.toArray();
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tempRevision = objectArray[n2];
            IFileRevision revision = (IFileRevision)tempRevision;
            if (revision == null || !revision.exists()) {
                MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)"Deleted Revision", (String)"Can't open a deleted revision");
            } else {
                IRunnableWithProgress runnable = monitor -> {
                    try {
                        IStorage file = revision.getStorage(monitor);
                        String id = this.getEditorID(file.getName(), file.getContents());
                        if (file instanceof IFile) {
                            IDE.openEditor((IWorkbenchPage)this.page.getSite().getPage(), (IFile)((IFile)file));
                        } else {
                            FileSystemRevisionEditorInput fileRevEditorInput = new FileSystemRevisionEditorInput(revision);
                            if (!this.editorAlreadyOpenOnContents(fileRevEditorInput)) {
                                this.page.getSite().getPage().openEditor((IEditorInput)fileRevEditorInput, id);
                            }
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                };
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progressService.run(false, false, runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    String getEditorID(String fileName, InputStream contents) {
        IEditorDescriptor descriptor;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        String id = (descriptor = registry.getDefaultEditor(fileName, type)) == null || descriptor.isOpenExternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        return this.shouldShow();
    }

    public void setPage(HistoryPage page) {
        this.page = page;
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            IFileRevision revision = (IFileRevision)obj;
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean editorAlreadyOpenOnContents(FileSystemRevisionEditorInput input) {
        IEditorReference[] editorRefs;
        IEditorReference[] iEditorReferenceArray = editorRefs = this.page.getSite().getPage().getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevision editorRevision;
            IFileRevision inputRevision;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart part = editorRef.getEditor(false);
            if (part != null && part.getEditorInput() instanceof FileSystemRevisionEditorInput && (inputRevision = input.getAdapter(IFileRevision.class)).equals(editorRevision = (IFileRevision)part.getEditorInput().getAdapter(IFileRevision.class))) {
                this.page.getSite().getPage().activate((IWorkbenchPart)part);
                return true;
            }
            ++n2;
        }
        return false;
    }
}

