/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.Policy;

public class ProjectSetSerializer
implements IProjectSetSerializer {
    public String[] asReference(IProject[] providerProjects, Object context, IProgressMonitor monitor) {
        Assert.isTrue((boolean)(context instanceof Shell));
        ArrayList<String> refs = new ArrayList<String>();
        IProject[] iProjectArray = providerProjects;
        int n = providerProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
            if (provider != null) {
                refs.add(this.asReference(provider));
            }
            ++n2;
        }
        return refs.toArray(new String[refs.size()]);
    }

    public IProject[] addToWorkspace(String[] referenceStrings, String filename, Object context, IProgressMonitor monitor) {
        Assert.isTrue((boolean)(context instanceof Shell));
        ArrayList<IProject> projects = new ArrayList<IProject>();
        String[] stringArray = referenceStrings;
        int n = referenceStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String projectName = this.getProjectName(string);
            String path = this.getPath(string);
            if (projectName != null && path != null) {
                try {
                    IProject project = this.createProject(projectName, monitor);
                    RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
                    FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)project);
                    provider.setTargetLocation(path);
                    projects.add(project);
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)((Shell)context), (String)Policy.bind("ConfigurationWizard.errorMapping"), (String)Policy.bind("ConfigurationWizard.error"), (IStatus)e.getStatus());
                }
            }
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private String asReference(FileSystemProvider provider) {
        return provider.getProject().getName() + "," + provider.getRoot().toString();
    }

    private String getProjectName(String string) {
        int i = string.indexOf(44);
        if (i == -1) {
            return null;
        }
        return string.substring(0, i);
    }

    private String getPath(String string) {
        int i = string.indexOf(44);
        if (i == -1) {
            return null;
        }
        return string.substring(i + 1);
    }

    private IProject createProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            project.create(monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        return project;
    }
}

