/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.localhistory;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.examples.localhistory.LocalHistorySyncInfo;
import org.eclipse.team.examples.localhistory.LocalHistoryVariant;
import org.eclipse.team.examples.localhistory.LocalHistoryVariantComparator;

public class LocalHistorySubscriber
extends Subscriber {
    private final LocalHistoryVariantComparator comparator = new LocalHistoryVariantComparator();

    public String getName() {
        return "Local History Subscriber";
    }

    public boolean isSupervised(IResource resource) {
        return true;
    }

    public IResource[] members(IResource resource) throws TeamException {
        try {
            if (resource.getType() == 1) {
                return new IResource[0];
            }
            IContainer container = (IContainer)resource;
            ArrayList<IResource> existingChildren = new ArrayList<IResource>(Arrays.asList(container.members()));
            existingChildren.addAll(Arrays.asList(container.findDeletedMembersWithHistory(2, null)));
            return existingChildren.toArray(new IResource[existingChildren.size()]);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    public IResource[] roots() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        try {
            IFile file;
            IFileState[] states;
            LocalHistoryVariant variant = null;
            if (resource.getType() == 1 && (states = (file = (IFile)resource).getHistory(null)).length > 0) {
                variant = new LocalHistoryVariant(states[0]);
            }
            LocalHistorySyncInfo info = new LocalHistorySyncInfo(resource, variant, this.comparator);
            info.init();
            return info;
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparator;
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) {
    }
}

