/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.examples.model.ModelFolder;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelProject;
import org.eclipse.team.examples.model.ModelWorkspace;

public abstract class ModelObject
extends PlatformObject {
    public static ModelObject create(IResource resource) {
        switch (resource.getType()) {
            case 8: {
                return new ModelWorkspace();
            }
            case 4: {
                return new ModelProject((IProject)resource);
            }
            case 2: {
                return new ModelFolder((IFolder)resource);
            }
            case 1: {
                if (!ModelObjectDefinitionFile.isModFile(resource)) break;
                return new ModelObjectDefinitionFile((IFile)resource);
            }
        }
        return null;
    }

    public abstract String getName();

    public abstract String getPath();

    public abstract ModelObject[] getChildren() throws CoreException;

    public abstract ModelObject getParent();

    public abstract void delete() throws CoreException;

    public abstract ModelProject getProject();
}

