/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelFile;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectElementFile;

public class ModelObjectDefinitionFile
extends ModelFile {
    public static final String MODEL_OBJECT_DEFINITION_FILE_EXTENSION = "mod";

    public static boolean isModFile(IResource resource) {
        String fileExtension;
        if (resource instanceof IFile && (fileExtension = resource.getFileExtension()) != null) {
            return fileExtension.equals(MODEL_OBJECT_DEFINITION_FILE_EXTENSION);
        }
        return false;
    }

    public static IResource[] getReferencedResources(String projectName, IStorage storage) throws CoreException {
        String[] filePaths;
        if (storage == null) {
            return new IResource[0];
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        String[] stringArray = filePaths = ModelObjectDefinitionFile.readLines(storage);
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IFile file = ModelObjectDefinitionFile.getFile(projectName, path);
            if (file != null && file.getFileExtension() != null && file.getFileExtension().equals("moe")) {
                result.add(file);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public ModelObjectDefinitionFile(IFile file) {
        super(file);
    }

    @Override
    public ModelObject[] getChildren() throws CoreException {
        return this.getModelObjectElementFiles();
    }

    public ModelObjectElementFile[] getModelObjectElementFiles() throws CoreException {
        String[] filePaths;
        ArrayList<ModelObjectElementFile> result = new ArrayList<ModelObjectElementFile>();
        String[] stringArray = filePaths = ModelObjectDefinitionFile.readLines((IStorage)((IFile)this.getResource()));
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            ModelObjectElementFile moeFile;
            String path = stringArray[n2];
            IFile file = ModelObjectDefinitionFile.getFile(this.getResource().getProject().getName(), path);
            if (file != null && (moeFile = this.getMoeFile(file)) != null) {
                result.add(moeFile);
            }
            ++n2;
        }
        return result.toArray(new ModelObjectElementFile[result.size()]);
    }

    private static String[] readLines(IStorage file) throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));){
                String line = null;
                ArrayList<String> result = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    result.add(line.trim());
                }
                return result.toArray(new String[result.size()]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.team.examples.filesystem", 0, NLS.bind((String)"Error reading from file {0}", (Object)file.getFullPath()), (Throwable)e));
        }
    }

    private void writeLines(String[] strings) throws CoreException {
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            buffer.append(string);
            buffer.append("\n");
            ++n2;
        }
        ((IFile)this.getResource()).setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), false, true, null);
    }

    private ModelObjectElementFile getMoeFile(IFile file) {
        if (ModelObjectElementFile.isMoeFile((IResource)file)) {
            return new ModelObjectElementFile(this, file);
        }
        return null;
    }

    private static IFile getFile(String projectName, String path) {
        if (path.length() == 0) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validatePath("/" + projectName + "/" + path, 1);
        if (status.isOK()) {
            IProject project = workspace.getRoot().getProject(projectName);
            return project.getFile(IPath.fromOSString((String)path));
        }
        FileSystemPlugin.log(status);
        return null;
    }

    public void addMoe(IFile file) throws CoreException {
        ((IFile)this.getResource()).appendContents((InputStream)new ByteArrayInputStream(("\n" + String.valueOf(file.getProjectRelativePath())).getBytes()), false, true, null);
    }

    public void remove(ModelObjectElementFile file) throws CoreException {
        ModelObjectElementFile[] files = this.getModelObjectElementFiles();
        ArrayList<String> paths = new ArrayList<String>();
        ModelObjectElementFile[] modelObjectElementFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ModelObjectElementFile child = modelObjectElementFileArray[n2];
            if (!child.equals((Object)file)) {
                paths.add(child.getResource().getProjectRelativePath().toString());
            }
            ++n2;
        }
        this.writeLines(paths.toArray(new String[paths.size()]));
    }

    @Override
    public void delete() throws CoreException {
        ModelObjectElementFile[] files = this.getModelObjectElementFiles();
        super.delete();
        ModelObjectElementFile[] modelObjectElementFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ModelObjectElementFile file = modelObjectElementFileArray[n2];
            file.getResource().delete(false, null);
            ++n2;
        }
    }

    public void setElements(IResource[] resources) throws CoreException {
        ArrayList<String> paths = new ArrayList<String>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            paths.add(resource.getProjectRelativePath().toString());
            ++n2;
        }
        this.writeLines(paths.toArray(new String[paths.size()]));
    }

    public boolean hasMoe(IFile file) throws CoreException {
        ModelObjectElementFile[] files;
        ModelObjectElementFile[] modelObjectElementFileArray = files = this.getModelObjectElementFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ModelObjectElementFile child = modelObjectElementFileArray[n2];
            if (child.getResource().equals((Object)file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

