/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.mapping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.examples.model.ModelResource;
import org.eclipse.team.examples.model.mapping.ModelResourceMapping;

public class ModResourceMapping
extends ModelResourceMapping {
    public ModResourceMapping(ModelObjectDefinitionFile file) {
        super(file);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        Set<IResource> resources = this.getLocalResources();
        if (context instanceof RemoteResourceMappingContext) {
            IResource[] remoteResources;
            monitor.beginTask(null, -1);
            RemoteResourceMappingContext remoteContext = (RemoteResourceMappingContext)context;
            if (remoteContext.hasRemoteChange(this.getResource(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)-1))) {
                remoteResources = ModelObjectDefinitionFile.getReferencedResources(this.getResource().getProject().getName(), remoteContext.fetchRemoteContents((IFile)this.getResource(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)-1)));
                Collections.addAll(resources, remoteResources);
            }
            if (remoteContext.isThreeWay() && remoteContext.hasLocalChange(this.getResource(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)-1))) {
                remoteResources = ModelObjectDefinitionFile.getReferencedResources(this.getResource().getProject().getName(), remoteContext.fetchBaseContents((IFile)this.getResource(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)-1)));
                Collections.addAll(resources, remoteResources);
            }
            monitor.done();
        }
        return new ResourceTraversal[]{new ResourceTraversal(resources.toArray(new IResource[resources.size()]), 0, 0)};
    }

    private IResource getResource() {
        return ((ModelResource)((Object)this.getModelObject())).getResource();
    }

    private Set<IResource> getLocalResources() throws CoreException {
        ModelObjectElementFile[] files;
        ModelObjectDefinitionFile mdf = (ModelObjectDefinitionFile)((Object)this.getModelObject());
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.add(mdf.getResource());
        ModelObjectElementFile[] modelObjectElementFileArray = files = mdf.getModelObjectElementFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ModelObjectElementFile file = modelObjectElementFileArray[n2];
            resources.add(file.getResource());
            ++n2;
        }
        return resources;
    }

    public boolean contains(ResourceMapping mapping) {
        ModelObject object;
        if (mapping instanceof ModelResourceMapping && (object = (ModelObject)((Object)mapping.getModelObject())) instanceof ModelResource) {
            IResource resource = ((ModelResource)object).getResource();
            try {
                return this.getLocalResources().contains(resource);
            }
            catch (CoreException e) {
                FileSystemPlugin.log(e);
            }
        }
        return false;
    }
}

