/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelProject;
import org.eclipse.team.examples.model.ModelWorkspace;
import org.eclipse.team.examples.model.ui.ModelSaveablesProvider;
import org.eclipse.team.ui.mapping.ITeamStateChangeEvent;
import org.eclipse.team.ui.mapping.ITeamStateChangeListener;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.ui.navigator.SaveablesProvider;

public class ModelNavigatorContentProvider
extends BaseWorkbenchContentProvider
implements ICommonContentProvider,
IResourceChangeListener,
IPipelinedTreeContentProvider,
ITeamStateChangeListener,
IAdaptable {
    private ICommonContentExtensionSite extensionSite;
    private boolean isWorkspaceRoot;
    private Viewer viewer;
    private final boolean updateViewer;
    private SynchronizationStateTester syncStateTester;
    private final Object saveablesProvider = new ModelSaveablesProvider();

    public ModelNavigatorContentProvider() {
        this.updateViewer = true;
    }

    public ModelNavigatorContentProvider(boolean updateViewer) {
        this.updateViewer = updateViewer;
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.extensionSite = aConfig;
        if (this.updateViewer) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            this.syncStateTester = new SynchronizationStateTester();
            this.syncStateTester.getTeamStateProvider().addDecoratedStateChangeListener((ITeamStateChangeListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.syncStateTester != null) {
            this.syncStateTester.getTeamStateProvider().removeDecoratedStateChangeListener((ITeamStateChangeListener)this);
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public ICommonContentExtensionSite getExtensionSite() {
        return this.extensionSite;
    }

    public Object[] getElements(Object element) {
        if (element instanceof IWorkspaceRoot) {
            this.isWorkspaceRoot = true;
            return super.getElements((Object)ModelObject.create((IResource)((IWorkspaceRoot)element)));
        }
        return super.getElements(element);
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (this.isWorkspaceRoot && parent instanceof ModelWorkspace) {
            return ((ModelWorkspace)((Object)parent)).getResource();
        }
        return parent;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void teamStateChanged(ITeamStateChangeEvent event) {
        IResource[] changed;
        IResource[] removedRoots;
        IResource[] addedRoots;
        HashSet<ModelProject> refreshProjects = new HashSet<ModelProject>();
        IResource[] iResourceArray = addedRoots = event.getAddedRoots();
        int n = addedRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (this.isModelProject((IResource)resource.getProject())) {
                refreshProjects.add((ModelProject)ModelObject.create((IResource)resource.getProject()));
            }
            ++n2;
        }
        IResource[] iResourceArray2 = removedRoots = event.getRemovedRoots();
        int n3 = removedRoots.length;
        n = 0;
        while (n < n3) {
            IResource resource = iResourceArray2[n];
            if (this.isModelProject((IResource)resource.getProject())) {
                refreshProjects.add((ModelProject)ModelObject.create((IResource)resource.getProject()));
            }
            ++n;
        }
        IResource[] iResourceArray3 = changed = event.getChangedResources();
        int n4 = changed.length;
        n3 = 0;
        while (n3 < n4) {
            IResource resource = iResourceArray3[n3];
            if (this.isModelProject((IResource)resource.getProject())) {
                refreshProjects.add((ModelProject)ModelObject.create((IResource)resource.getProject()));
            }
            ++n3;
        }
        this.refreshProjects(refreshProjects.toArray(new ModelProject[refreshProjects.size()]));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.viewer == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        IResourceDelta[] children = delta.getAffectedChildren();
        boolean refreshAll = false;
        ArrayList<ModelProject> refreshProjects = new ArrayList<ModelProject>();
        IResourceDelta[] iResourceDeltaArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            if (this.isModelProject(childDelta.getResource())) {
                if (this.isProjectChange(childDelta)) {
                    refreshAll = true;
                    break;
                }
                refreshProjects.add((ModelProject)ModelObject.create(childDelta.getResource()));
            }
            ++n2;
        }
        if (refreshAll || !refreshProjects.isEmpty()) {
            if (refreshAll) {
                this.refreshViewer();
            } else {
                this.refreshProjects(refreshProjects.toArray(new ModelProject[refreshProjects.size()]));
            }
        }
    }

    private void refreshProjects(ModelProject[] projects) {
        Display.getDefault().asyncExec(() -> {
            if (!this.getViewer().getControl().isDisposed()) {
                ModelProject[] modelProjectArray2 = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelProject project = modelProjectArray2[n2];
                    ((AbstractTreeViewer)this.getViewer()).refresh((Object)project, true);
                    ++n2;
                }
            }
        });
    }

    private void refreshViewer() {
        Display.getDefault().asyncExec(() -> {
            if (!this.getViewer().getControl().isDisposed()) {
                this.getViewer().refresh();
            }
        });
    }

    private boolean isProjectChange(IResourceDelta childDelta) {
        return (childDelta.getFlags() & 0x84000) > 0;
    }

    private boolean isModelProject(IResource resource) {
        try {
            return ModelProject.isModProject(resource.getProject());
        }
        catch (CoreException e) {
            FileSystemPlugin.log(e);
            return false;
        }
    }

    Viewer getViewer() {
        return this.viewer;
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
        if (anInput instanceof IWorkspaceRoot) {
            ArrayList<ModelObject> newProjects = new ArrayList<ModelObject>();
            Iterator iter = theCurrentElements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IProject)) continue;
                IProject project = (IProject)element;
                try {
                    if (!ModelProject.isModProject(project)) continue;
                    iter.remove();
                    newProjects.add(ModelObject.create((IResource)project));
                }
                catch (CoreException e) {
                    FileSystemPlugin.log(e);
                }
            }
            theCurrentElements.addAll(newProjects);
        }
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        if (anAddModification.getParent() instanceof IWorkspaceRoot) {
            Iterator iter = anAddModification.getChildren().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IProject)) continue;
                IProject project = (IProject)element;
                try {
                    if (!ModelProject.isModProject(project)) continue;
                    iter.remove();
                }
                catch (CoreException e) {
                    FileSystemPlugin.log(e);
                }
            }
        }
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return false;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return aRemoveModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == SaveablesProvider.class) {
            return adapter.cast(this.saveablesProvider);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

