/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ui.ModelSaveablesProvider;
import org.eclipse.team.examples.model.ui.ModelWorkbenchAdapter;
import org.eclipse.ui.Saveable;

public class ModelSaveable
extends Saveable {
    private final ModelObject modelObject;
    private boolean dirty;
    private final ModelSaveablesProvider modelSaveablesProvider;

    public ModelSaveable(ModelSaveablesProvider modelSaveablesProvider, ModelObjectDefinitionFile mo) {
        this.modelSaveablesProvider = modelSaveablesProvider;
        this.modelObject = mo;
    }

    public boolean equals(Object object) {
        if (object instanceof ModelSaveable) {
            ModelSaveable other = (ModelSaveable)((Object)object);
            return ((Object)((Object)other.getModelObject())).equals((Object)this.getModelObject());
        }
        return false;
    }

    public ModelObject getModelObject() {
        return this.modelObject;
    }

    public ImageDescriptor getImageDescriptor() {
        return ModelWorkbenchAdapter.createImageDescriptor("obj/mod_obj.gif");
    }

    public String getName() {
        return this.modelObject.getName();
    }

    public String getToolTipText() {
        return "Saveable for " + this.getName();
    }

    public int hashCode() {
        return ((Object)((Object)this.modelObject)).hashCode();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        this.dirty = false;
        this.modelSaveablesProvider.saved(this);
    }

    public void makeDirty() {
        this.dirty = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ResourceMapping.class) {
            return (T)Adapters.adapt((Object)((Object)this.getModelObject()), adapter);
        }
        return (T)super.getAdapter(adapter);
    }
}

