/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui.mapping;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.examples.model.ModelResource;
import org.eclipse.team.examples.model.mapping.ExampleModelProvider;
import org.eclipse.team.ui.mapping.SynchronizationCompareAdapter;
import org.eclipse.ui.IMemento;

public class CompareAdapter
extends SynchronizationCompareAdapter {
    private static final String CTX_MODEL_MAPPINGS = "org.eclipse.team.examples.filesystem.modelMappings";
    private final ExampleModelProvider provider;

    public CompareAdapter(ExampleModelProvider provider) {
        this.provider = provider;
    }

    public String getName(ResourceMapping mapping) {
        Object o = mapping.getModelObject();
        if (o instanceof ModelObject) {
            return ((ModelObject)((Object)o)).getName();
        }
        return super.getName(mapping);
    }

    public String getPathString(ResourceMapping mapping) {
        Object o = mapping.getModelObject();
        if (o instanceof ModelObject) {
            return ((ModelObject)((Object)o)).getPath();
        }
        return super.getPathString(mapping);
    }

    public ICompareInput asCompareInput(ISynchronizationContext context, Object o) {
        if (o instanceof ModelObjectElementFile) {
            ModelObjectElementFile moeFile = (ModelObjectElementFile)((Object)o);
            return super.asCompareInput(context, (Object)moeFile.getResource());
        }
        return super.asCompareInput(context, o);
    }

    public ResourceMapping[] restore(IMemento memento) {
        IMemento[] children;
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IMemento[] iMementoArray = children = memento.getChildren(CTX_MODEL_MAPPINGS);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            ResourceMapping mapping = this.restoreMapping(child);
            if (mapping != null) {
                result.add(mapping);
            }
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public void save(ResourceMapping[] mappings, IMemento memento) {
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            Object o = mapping.getModelObject();
            if (o instanceof ModelObject) {
                ModelObject mo = (ModelObject)((Object)o);
                this.save(mo, memento.createChild(CTX_MODEL_MAPPINGS));
            }
            ++n2;
        }
    }

    private ResourceMapping restoreMapping(IMemento child) {
        String parent = child.getString("definition");
        String path = child.getString("resource");
        if (parent != null) {
            ModelObjectDefinitionFile modFile = (ModelObjectDefinitionFile)ModelObject.create(this.getResource(parent));
            if (modFile != null) {
                return (ResourceMapping)new ModelObjectElementFile(modFile, (IFile)this.getResource(path)).getAdapter(ResourceMapping.class);
            }
        } else {
            ModelObject object = ModelObject.create(this.getResource(path));
            if (object != null) {
                return (ResourceMapping)object.getAdapter(ResourceMapping.class);
            }
        }
        return null;
    }

    private IResource getResource(String path) {
        IPath resourcePath = IPath.fromOSString((String)path);
        if (path.endsWith("mod") || path.endsWith("moe")) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(resourcePath);
        }
        if (resourcePath.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(resourcePath.lastSegment());
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(resourcePath);
    }

    private void save(ModelObject mo, IMemento memento) {
        if (mo instanceof ModelResource) {
            ModelResource resource = (ModelResource)mo;
            memento.putString("resource", resource.getResource().getFullPath().toString());
            if (mo instanceof ModelObjectElementFile) {
                ModelObjectElementFile moeFile = (ModelObjectElementFile)mo;
                ModelObjectDefinitionFile parent = (ModelObjectDefinitionFile)moeFile.getParent();
                memento.putString("definition", parent.getResource().getFullPath().toString());
            }
        }
    }

    public ModelProvider getProvider() {
        return this.provider;
    }
}

