/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.internal.ui.mapping.ResourceModelProviderOperation;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ModelMergeActionHandler
extends MergeActionHandler {
    final boolean overwrite;
    private SynchronizationOperation operation;

    public ModelMergeActionHandler(ISynchronizePageConfiguration configuration, boolean overwrite) {
        super(configuration);
        this.overwrite = overwrite;
    }

    protected SynchronizationOperation getOperation() {
        if (this.operation == null) {
            this.operation = new ModelSynchronizeOperation(this.getConfiguration(), this.getStructuredSelection());
        }
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEnablement(IStructuredSelection selection) {
        ModelMergeActionHandler modelMergeActionHandler = this;
        synchronized (modelMergeActionHandler) {
            this.operation = null;
        }
        super.updateEnablement(selection);
    }

    private final class ModelSynchronizeOperation
    extends ResourceModelProviderOperation {
        public ModelSynchronizeOperation(ISynchronizePageConfiguration configuration, IStructuredSelection selection) {
            super(configuration, selection);
        }

        protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                IMergeContext context = (IMergeContext)this.getContext();
                IDiff[] diffs = this.getTargetDiffs();
                ModelObjectElementFile[] moeMerges = this.getMoeOnlyMerges();
                IStatus status = context.merge(diffs, ModelMergeActionHandler.this.overwrite, monitor);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                ModelObjectElementFile[] modelObjectElementFileArray = moeMerges;
                int n = moeMerges.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelObjectElementFile file = modelObjectElementFileArray[n2];
                    ModelObjectDefinitionFile modFile = (ModelObjectDefinitionFile)file.getParent();
                    if (file.getResource().exists() && !modFile.hasMoe((IFile)file.getResource())) {
                        modFile.addMoe((IFile)file.getResource());
                    } else {
                        modFile.remove(file);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }

        private ModelObjectElementFile[] getMoeOnlyMerges() {
            Object[] elements;
            ArrayList<ModelObjectElementFile> result = new ArrayList<ModelObjectElementFile>();
            Object[] objectArray = elements = this.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ModelObjectElementFile) {
                    ModelObjectElementFile moeFile = (ModelObjectElementFile)((Object)object);
                    result.add(moeFile);
                }
                ++n2;
            }
            return result.toArray(new ModelObjectElementFile[result.size()]);
        }

        protected FastDiffFilter getDiffFilter() {
            return new FastDiffFilter(){

                public boolean select(IDiff node) {
                    if (node instanceof IThreeWayDiff) {
                        IThreeWayDiff twd = (IThreeWayDiff)node;
                        return twd.getDirection() == 256 && ((ModelSynchronizeOperation)ModelSynchronizeOperation.this).ModelMergeActionHandler.this.overwrite || twd.getDirection() == 768 || twd.getDirection() == 512;
                    }
                    return ((ModelSynchronizeOperation)ModelSynchronizeOperation.this).ModelMergeActionHandler.this.overwrite;
                }
            };
        }
    }
}

